/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpTrapNotificationStrategy
implements NotificationStrategy {
    private List<Argument> m_arguments;

    @Override
    public int send(List<Argument> arguments) {
        block6: {
            this.m_arguments = arguments;
            String argVersion = this.getVersion();
            if (argVersion == null) {
                this.log().info("send: trapVersion paramenter is null, defaulting to \"v1\".");
                argVersion = "v1";
            }
            try {
                if (argVersion.equals("v1")) {
                    this.sendV1Trap();
                    break block6;
                }
                if (argVersion.equals("v2c") || argVersion.equals("v2")) {
                    this.sendV2Trap();
                    break block6;
                }
                if (argVersion.equals("v3")) {
                    this.log().info("send: Version3 not supported in notifications, yet, falling back to v2c.");
                    this.sendV2Trap();
                    break block6;
                }
                this.log().info("send: No version specified in first argument to notification.");
                return 1;
            }
            catch (Exception e) {
                this.log().info("send: Exception trying to send trap. ", (Throwable)e);
                return 1;
            }
        }
        return 0;
    }

    private String getVersion() {
        return this.getSwitchValue("trapVersion");
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void sendV1Trap() throws Exception {
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)this.getEnterpriseId()));
        pdu.setGeneric(this.getGenericId());
        pdu.setSpecific(this.getSpecificId());
        pdu.setTimeStamp(0L);
        InetAddress agentAddress = this.getHostInetAddress();
        pdu.setAgentAddress(agentAddress);
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.4.1.5813.20.1"), SnmpUtils.getValueFactory().getOctetString(this.getVarbind().getBytes()));
        pdu.send(agentAddress.getHostAddress(), this.getPort(), this.getCommunity());
    }

    public void sendV2Trap() throws Exception {
        SnmpObjId trapOID;
        SnmpObjId enterpriseId = SnmpObjId.get((String)this.getEnterpriseId());
        boolean isGeneric = false;
        if (SnmpObjId.get((String)".1.3.6.1.6.3.1.1.5").isPrefixOf(enterpriseId)) {
            isGeneric = true;
            trapOID = enterpriseId;
        } else {
            trapOID = SnmpObjId.get((SnmpObjId)enterpriseId, (SnmpObjId)new SnmpInstId(this.getSpecificId()));
        }
        SnmpTrapBuilder pdu = SnmpUtils.getV2TrapBuilder();
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.2.1.1.3.0"), SnmpUtils.getValueFactory().getTimeTicks(0L));
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.1.0"), SnmpUtils.getValueFactory().getObjectId(trapOID));
        if (isGeneric) {
            pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.3.0"), SnmpUtils.getValueFactory().getObjectId(enterpriseId));
        }
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.4.1.5813.20.1"), SnmpUtils.getValueFactory().getOctetString(this.getVarbind().getBytes()));
        pdu.send(this.getHostInetAddress().getHostAddress(), this.getPort(), this.getCommunity());
    }

    private InetAddress getHostInetAddress() throws UnknownHostException {
        String switchValue = this.getSwitchValue("trapHost");
        if (switchValue == null) {
            this.log().info("getHostInetAddress: trapHost not specified, defaulting to: \"127.0.0.1\".");
            switchValue = "127.0.0.1";
        } else {
            this.log().debug("getHostInetAddress: trapHost argument: " + switchValue);
        }
        return InetAddress.getByName(switchValue);
    }

    private int getPort() {
        String switchValue = this.getSwitchValue("trapPort");
        if (switchValue == null) {
            this.log().info("getPort: trapPort argument not specified, defaulting to: \"162\".");
            return 162;
        }
        this.log().debug("getPort: trapPort argument: " + Integer.parseInt(switchValue));
        return Integer.parseInt(switchValue);
    }

    private String getCommunity() {
        String switchValue = this.getSwitchValue("trapCommunity");
        if (switchValue == null) {
            this.log().info("getCommunity: trapCommunity not specified, defaulting to: \"public\".");
            switchValue = "public";
        } else {
            this.log().debug("getCommunity: trapCommunity argument: " + switchValue);
        }
        return switchValue;
    }

    private String getEnterpriseId() {
        String switchValue = this.getSwitchValue("trapEnterprise");
        if (switchValue == null) {
            this.log().info("getEnterpriseId: trapEnterprise not specified, defaulting to: \".1.3.6.1.4.1.5813\".");
            switchValue = ".1.3.6.1.4.1.5813";
        } else {
            this.log().debug("getEnterpriseId: trapEnterprise argument: " + switchValue);
        }
        return switchValue;
    }

    private int getGenericId() {
        String switchValue = this.getSwitchValue("trapGeneric");
        if (switchValue == null) {
            this.log().info("getGenericId: trapGeneric argument not specified, defaulting to: \"6\".");
            return 6;
        }
        this.log().debug("getGenericId: trapGeneric argument: " + switchValue);
        return Integer.parseInt(switchValue);
    }

    private int getSpecificId() {
        String switchValue = this.getSwitchValue("trapSpecific");
        if (switchValue == null) {
            this.log().info("getSpecificId: trapSpecific argument not specified, defaulting to: \"1\".");
            return 1;
        }
        this.log().debug("getSpecificId: trapSpecific argument: " + Integer.parseInt(switchValue));
        return Integer.parseInt(switchValue);
    }

    private String getVarbind() {
        String switchValue = this.getSwitchValue("trapVarbind");
        if (switchValue == null) {
            this.log().info("getVarbind: trapVarbind argument not specified, defaulting to: \"OpenNMS Trap Notification\".");
            return "OpenNMS Trap Notification";
        }
        this.log().debug("getVarbind: trapVarbind argument: " + switchValue);
        return switchValue;
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }
}

