/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.ScheduleTimer;

public class Scheduler
implements Runnable,
PausableFiber,
ScheduleTimer {
    public Map<Long, PeekableFifoQueue<ReadyRunnable>> m_queues;
    public int m_scheduled;
    public RunnableConsumerThreadPool m_runner;
    private String m_name;
    public int m_status;
    private Thread m_worker;

    public Scheduler(String parent, int maxSize) {
        this.m_name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(this.m_name + " Pool", 0.6f, 1.0f, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public Scheduler(String parent, int maxSize, float lowMark, float hiMark) {
        this.m_name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(this.m_name + " Pool", lowMark, hiMark, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public synchronized void schedule(ReadyRunnable runnable, long interval) {
        LogUtils.debugf((Object)this, (String)"schedule: Adding ready runnable at interval %d", (Object[])new Object[]{interval});
        if (!this.m_queues.containsKey(interval)) {
            LogUtils.debugf((Object)this, (String)"schedule: interval queue did not exist, a new one has been created", (Object[])new Object[0]);
            this.m_queues.put(interval, new PeekableFifoQueue());
        }
        try {
            this.m_queues.get(interval).add(runnable);
            if (this.m_scheduled++ == 0) {
                LogUtils.debugf((Object)this, (String)"schedule: queue element added, calling notify all since none were scheduled", (Object[])new Object[0]);
                this.notifyAll();
            } else {
                LogUtils.debugf((Object)this, (String)"schedule: queue element added, notification not performed", (Object[])new Object[0]);
            }
        }
        catch (InterruptedException ie) {
            LogUtils.infof((Object)this, (Throwable)ie, (String)"schedule: failed to add new ready runnable instance %s to scheduler", (Object[])new Object[]{runnable});
            Thread.currentThread().interrupt();
        }
        catch (FifoQueueException ex) {
            LogUtils.infof((Object)this, (Throwable)ex, (String)"schedule: failed to add new ready runnable instance %s to scheduler", (Object[])new Object[]{runnable});
        }
    }

    public synchronized void schedule(long interval, final ReadyRunnable runnable) {
        final long timeToRun = this.getCurrentTime() + interval;
        ReadyRunnable timeKeeper = new ReadyRunnable(){

            public boolean isReady() {
                return Scheduler.this.getCurrentTime() >= timeToRun && runnable.isReady();
            }

            public String getInfo() {
                return runnable.getInfo();
            }

            public void run() {
                runnable.run();
            }

            public void schedule() {
                runnable.schedule();
            }

            public void suspend() {
                runnable.suspend();
            }

            public void wakeUp() {
                runnable.wakeUp();
            }

            public boolean isSuspended() {
                return runnable.isSuspended();
            }

            public boolean equals(ReadyRunnable r) {
                return runnable.equals(r);
            }

            public void unschedule() {
                runnable.unschedule();
            }

            public String toString() {
                return runnable.toString() + " (ready in " + Math.max(0L, timeToRun - Scheduler.this.getCurrentTime()) + "ms)";
            }

            public String getPackageName() {
                return runnable.getPackageName();
            }

            public void setPackageName(String pkg) {
                runnable.setPackageName(pkg);
            }
        };
        this.schedule(timeKeeper, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unschedule(ReadyRunnable runnable) {
        LogUtils.debugf((Object)this, (String)"unschedule: Removing all %s", (Object[])new Object[]{runnable.getInfo()});
        boolean done = false;
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            Iterator<Long> iter = this.m_queues.keySet().iterator();
            while (iter.hasNext() && !done) {
                Long key = iter.next();
                this.unschedule(runnable, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unschedule(ReadyRunnable runnable, long interval) {
        LogUtils.debugf((Object)this, (String)"unschedule: Removing %s at interval %d", (Object[])new Object[]{runnable.getInfo(), interval});
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            if (!this.m_queues.containsKey(interval)) {
                LogUtils.debugf((Object)this, (String)"unschedule: interval queue did not exist, exit", (Object[])new Object[0]);
                return;
            }
            PeekableFifoQueue<ReadyRunnable> in = this.m_queues.get(interval);
            if (in.isEmpty()) {
                LogUtils.debugf((Object)this, (String)"unschedule: interval queue is empty, exit", (Object[])new Object[0]);
                return;
            }
            ReadyRunnable readyRun = null;
            int maxLoops = in.size();
            boolean first = true;
            do {
                try {
                    readyRun = in.remove();
                    if (in.size() == maxLoops && first) {
                        ++maxLoops;
                    }
                    first = false;
                    if (readyRun != null && readyRun.equals(runnable)) {
                        LogUtils.debugf((Object)this, (String)"unschedule: removing found %s", (Object[])new Object[]{readyRun.getInfo()});
                        --this.m_scheduled;
                        continue;
                    }
                    in.add(readyRun);
                }
                catch (InterruptedException ie) {
                    LogUtils.infof((Object)this, (Throwable)ie, (String)"unschedule: failed to remove instance %s from scheduler", (Object[])new Object[]{runnable.getInfo()});
                    Thread.currentThread().interrupt();
                }
                catch (FifoQueueException ex) {
                    LogUtils.infof((Object)this, (Throwable)ex, (String)"unschedule: failed to remove instance %s from scheduler", (Object[])new Object[]{runnable.getInfo()});
                    throw new UndeclaredThrowableException(ex);
                }
            } while (--maxLoops > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        LogUtils.debugf((Object)this, (String)"getReadyRunnable: Retrieving %s", (Object[])new Object[]{runnable.getInfo()});
        ReadyRunnable rr = null;
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            Iterator<Long> iter = this.m_queues.keySet().iterator();
            while (iter.hasNext() && rr == null) {
                Long interval = iter.next();
                rr = this.getReadyRunnable(runnable, interval);
            }
        }
        if (rr == null) {
            LogUtils.infof((Object)this, (String)"getReadyRunnable: instance %s not found on scheduler", (Object[])new Object[]{runnable.getInfo()});
        }
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadyRunnable getReadyRunnable(ReadyRunnable runnable, long interval) {
        LogUtils.debugf((Object)this, (String)"getReadyRunnable: Retrieving %s at interval %d", (Object[])new Object[]{runnable.getInfo(), interval});
        if (!this.m_queues.containsKey(interval)) {
            LogUtils.debugf((Object)this, (String)"getReadyRunnable: interval queue did not exist, exit", (Object[])new Object[0]);
            return null;
        }
        ReadyRunnable rr = null;
        Map<Long, PeekableFifoQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            PeekableFifoQueue<ReadyRunnable> in = this.m_queues.get(interval);
            if (in.isEmpty()) {
                LogUtils.warnf((Object)this, (String)"getReadyRunnable: queue is Empty", (Object[])new Object[0]);
                return null;
            }
            int maxLoops = in.size();
            ReadyRunnable readyRun = null;
            boolean first = true;
            do {
                try {
                    readyRun = in.remove();
                    if (in.size() == maxLoops && first) {
                        ++maxLoops;
                    }
                    first = false;
                    if (readyRun != null && readyRun.equals(runnable)) {
                        LogUtils.debugf((Object)this, (String)"getReadyRunnable: found ready runnable %s", (Object[])new Object[]{readyRun});
                        rr = readyRun;
                    }
                    in.add(readyRun);
                }
                catch (InterruptedException ie) {
                    LogUtils.infof((Object)this, (Throwable)ie, (String)"getReadyRunnable: failed to get instance %s from scheduler", (Object[])new Object[]{readyRun.getInfo()});
                    Thread.currentThread().interrupt();
                }
                catch (FifoQueueException ex) {
                    LogUtils.infof((Object)this, (Throwable)ex, (String)"getReadyRunnable: failed to get instance %s from scheduler", (Object[])new Object[]{readyRun.getInfo()});
                    throw new UndeclaredThrowableException(ex);
                }
            } while (--maxLoops > 0);
        }
        if (rr == null) {
            LogUtils.infof((Object)this, (String)"getReadyRunnable: instance %s not found on scheduler", (Object[])new Object[]{runnable.getInfo()});
        }
        return rr;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        this.m_runner.start();
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        LogUtils.debugf((Object)this, (String)"start: scheduler started", (Object[])new Object[0]);
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        this.m_status = 3;
        this.m_worker.interrupt();
        this.m_runner.stop();
        LogUtils.debugf((Object)this, (String)"stop: scheduler stopped", (Object[])new Object[0]);
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_runner.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.m_status = 2;
        }
        LogUtils.debugf((Object)this, (String)"run: scheduler running", (Object[])new Object[0]);
        while (true) {
            scheduler = this;
            synchronized (scheduler) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    LogUtils.debugf((Object)this, (String)"run: status = %s, time to exit", (Object[])new Object[]{this.m_status});
                    break;
                }
                if (this.m_scheduled == 0) {
                    try {
                        LogUtils.debugf((Object)this, (String)"run: no interfaces scheduled, waiting...", (Object[])new Object[0]);
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            int runned = 0;
            FifoQueue out = this.m_runner.getRunQueue();
            Object object = this.m_queues;
            synchronized (object) {
                for (Long key : this.m_queues.keySet()) {
                    PeekableFifoQueue<ReadyRunnable> in = this.m_queues.get(key);
                    if (in.isEmpty()) continue;
                    ReadyRunnable readyRun = null;
                    int maxLoops = in.size();
                    do {
                        try {
                            readyRun = in.peek();
                            if (readyRun == null || !readyRun.isReady()) continue;
                            LogUtils.debugf((Object)this, (String)"run: found ready runnable %s", (Object[])new Object[]{readyRun.getInfo()});
                            in.remove();
                            out.add((Object)readyRun);
                            ++runned;
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        catch (FifoQueueException qe) {
                            throw new UndeclaredThrowableException(qe);
                        }
                    } while (readyRun != null && readyRun.isReady() && --maxLoops > 0);
                }
            }
            object = this;
            synchronized (object) {
                this.m_scheduled -= runned;
                if (runned == 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        LogUtils.debugf((Object)this, (String)"run: scheduler exiting, state = STOPPED", (Object[])new Object[0]);
        Scheduler scheduler2 = this;
        synchronized (scheduler2) {
            this.m_status = 4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PeekableFifoQueue<T>
    extends FifoQueueImpl<T> {
        private T m_hold = null;

        PeekableFifoQueue() {
        }

        public synchronized T peek() throws InterruptedException, FifoQueueException {
            if (this.m_hold == null) {
                this.m_hold = super.remove(1L);
            }
            return this.m_hold;
        }

        public synchronized T remove() throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove();
            }
            return (T)rval;
        }

        public synchronized T remove(long timeout) throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove(timeout);
            }
            return (T)rval;
        }

        public boolean isEmpty() {
            if (this.m_hold != null) {
                return false;
            }
            return super.isEmpty();
        }
    }
}

