/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.sql.DataSource;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.opennms.netmgt.eventd.processor.EventProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public abstract class AbstractJdbcPersister
implements InitializingBean,
EventProcessor {
    protected static final int EVENT_UEI_FIELD_SIZE = 256;
    protected static final int EVENT_HOST_FIELD_SIZE = 256;
    protected static final int EVENT_INTERFACE_FIELD_SIZE = 16;
    protected static final int EVENT_DPNAME_FIELD_SIZE = 12;
    protected static final int EVENT_SNMPHOST_FIELD_SIZE = 256;
    protected static final int EVENT_SNMP_FIELD_SIZE = 256;
    protected static final int EVENT_LOGGRP_FIELD_SIZE = 32;
    protected static final int EVENT_PATHOUTAGE_FIELD_SIZE = 1024;
    protected static final int EVENT_CORRELATION_FIELD_SIZE = 1024;
    protected static final int EVENT_OPERINSTRUCT_FIELD_SIZE = 1024;
    protected static final int EVENT_AUTOACTION_FIELD_SIZE = 256;
    protected static final int EVENT_OPERACTION_FIELD_SIZE = 256;
    protected static final int EVENT_OPERACTION_MENU_FIELD_SIZE = 64;
    protected static final int EVENT_TTICKET_FIELD_SIZE = 128;
    protected static final int EVENT_FORWARD_FIELD_SIZE = 256;
    protected static final int EVENT_MOUSEOVERTEXT_FIELD_SIZE = 64;
    protected static final int EVENT_ACKUSER_FIELD_SIZE = 256;
    protected static final int EVENT_SOURCE_FIELD_SIZE = 128;
    protected static final int EVENT_X733_ALARMTYPE_SIZE = 31;
    protected static final char MSG_YES = 'Y';
    protected static final char MSG_NO = 'N';
    private EventdServiceManager m_eventdServiceManager;
    private DataSource m_dataSource;
    private String m_getNextIdString;

    protected void set(PreparedStatement stmt, int ndx, String value) throws SQLException {
        if (value == null || value.length() == 0) {
            stmt.setNull(ndx, 12);
        } else {
            stmt.setString(ndx, value);
        }
    }

    protected void set(PreparedStatement stmt, int ndx, int value) throws SQLException {
        if (value < 0) {
            stmt.setNull(ndx, 4);
        } else {
            stmt.setInt(ndx, value);
        }
    }

    protected void set(PreparedStatement stmt, int ndx, Timestamp value) throws SQLException {
        if (value == null) {
            stmt.setNull(ndx, 93);
        } else {
            stmt.setTimestamp(ndx, value);
        }
    }

    protected void set(PreparedStatement stmt, int ndx, char value) throws SQLException {
        stmt.setString(ndx, String.valueOf(value));
    }

    protected int getServiceID(String name) throws SQLException {
        return this.m_eventdServiceManager.getServiceId(name);
    }

    protected Timestamp getEventTime(Event event) {
        try {
            return new Timestamp(EventConstants.parseToDate((String)event.getTime()).getTime());
        }
        catch (ParseException e) {
            this.log().warn("Failed to convert time " + event.getTime() + " to Timestamp, setting current time instead.  Exception: " + e, (Throwable)e);
            return new Timestamp(System.currentTimeMillis());
        }
    }

    protected int getNextId() throws SQLException {
        return new JdbcTemplate(this.getDataSource()).queryForInt(this.getGetNextIdString());
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() throws SQLException {
        Assert.state((this.m_eventdServiceManager != null ? 1 : 0) != 0, (String)"property eventdServiceManager must be set");
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource must be set");
        Assert.state((this.m_getNextIdString != null ? 1 : 0) != 0, (String)"property getNextIdString must be set");
    }

    public EventdServiceManager getEventdServiceManager() {
        return this.m_eventdServiceManager;
    }

    public void setEventdServiceManager(EventdServiceManager eventdServiceManager) {
        this.m_eventdServiceManager = eventdServiceManager;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public String getGetNextIdString() {
        return this.m_getNextIdString;
    }

    public void setGetNextIdString(String getNextIdString) {
        this.m_getNextIdString = getNextIdString;
    }

    protected boolean checkEventSanityAndDoWeProcess(Event event, String logPrefix) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)event.getLogmsg(), (String)"event does not have a logmsg");
        if ("donotpersist".equals(event.getLogmsg().getDest())) {
            if (this.log().isDebugEnabled()) {
                this.log().debug(logPrefix + ": uei '" + event.getUei() + "' marked as 'donotpersist'; not processing event.");
            }
            return false;
        }
        return true;
    }
}

