/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;

public final class PollerConfigFactory
extends PollerConfigManager {
    private static PollerConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    @Deprecated
    public PollerConfigFactory(long currentVersion, Reader reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(reader, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    public PollerConfigFactory(long currentVersion, InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        super(stream, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (PollerConfigFactory.m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME);
        PollerConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
        stream = null;
        config = null;
        try {
            stream = new FileInputStream(cfgFile);
            config = new PollerConfigFactory(cfgFile.lastModified(), stream, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
            var5_4 = null;
            ** if (stream == null) goto lbl-1000
        }
        catch (Throwable var4_6) {
            var5_5 = null;
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
            throw var4_6;
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((InputStream)stream);
        }
lbl-1000:
        // 2 sources

        {
        }
        for (Package pollerPackage : config.getConfiguration().getPackageCollection()) {
            for (Service service : pollerPackage.getServiceCollection()) {
                for (Parameter parm : service.getParameterCollection()) {
                    if (!parm.getKey().equals("ds-name") || parm.getValue().length() <= 19) continue;
                    throw new ValidationException(String.format("ds-name '%s' in service '%s' (poller package '%s') is greater than %d characters", new Object[]{parm.getValue(), service.getName(), pollerPackage.getName(), 19}));
                }
            }
        }
        PollerConfigFactory.setInstance(config);
    }

    private static ThreadCategory logStatic() {
        return ThreadCategory.getInstance(PollerConfigFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        PollerConfigFactory.init();
        PollerConfigFactory.getInstance().update();
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME);
            PollerConfigFactory.logStatic().debug("saveXml: saving config file at " + timestamp + ": " + cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            PollerConfigFactory.logStatic().debug("saveXml: finished saving config file: " + cfgFile.getPath());
        }
    }

    public static synchronized PollerConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(PollerConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            block4: {
                this.m_currentVersion = cfgFile.lastModified();
                PollerConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(cfgFile);
                    this.unmarshalConfig(stream);
                    Object var4_3 = null;
                    if (stream == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
            PollerConfigFactory.init();
            PollerConfigFactory.logStatic().debug("init: finished loading config file: " + cfgFile.getPath());
        }
    }
}

