/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.snmp.SnmpInstId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfResourceType
extends ResourceType {
    private TreeMap<Integer, IfInfo> m_ifMap = new TreeMap();

    public IfResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        super(agent, snmpCollection);
        this.addKnownIfResources();
    }

    private Map<Integer, IfInfo> getIfMap() {
        return this.m_ifMap;
    }

    private void addIfInfo(IfInfo ifInfo) {
        this.getIfMap().put(ifInfo.getIndex(), ifInfo);
    }

    private void addKnownIfResources() {
        Set<IfInfo> ifInfos = this.getAgent().getSnmpInterfaceInfo(this);
        for (IfInfo ifInfo : ifInfos) {
            this.addIfInfo(ifInfo);
        }
    }

    @Override
    public SnmpInstId[] getCollectionInstances() {
        ArrayList<SnmpInstId> instances = new ArrayList<SnmpInstId>();
        for (IfInfo ifInfo : this.m_ifMap.values()) {
            if (!ifInfo.isCollectionEnabled()) continue;
            instances.add(new SnmpInstId(ifInfo.getIndex()));
        }
        return instances.toArray(new SnmpInstId[instances.size()]);
    }

    @Override
    public SnmpCollectionResource findResource(SnmpInstId inst) {
        return this.getIfMap().get(inst.toInt());
    }

    @Override
    public SnmpCollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        this.log().debug("findAliasedResource: Should not get called from IfResourceType");
        return null;
    }

    public Collection<IfInfo> getResources() {
        return this.m_ifMap.values();
    }

    @Override
    protected Collection<SnmpAttributeType> loadAttributeTypes() {
        return this.getCollection().getIndexedAttributeTypesForResourceType(this.getAgent(), this);
    }
}

