/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jfree.util.Log;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPlugin
extends AbstractPlugin {
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";

    @Override
    public String getProtocolName() {
        return null;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> map) {
        boolean retval = false;
        HttpClient httpClient = new HttpClient();
        HostConfiguration hostConfig = new HostConfiguration();
        GetMethod getMethod = new GetMethod(ParameterMap.getKeyedString(map, (String)"path", (String)DEFAULT_PATH));
        httpClient.getParams().setParameter("http.socket.timeout", (Object)ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT));
        httpClient.getParams().setParameter("http.useragent", (Object)ParameterMap.getKeyedString(map, (String)"user-agent", (String)DEFAULT_USER_AGENT));
        hostConfig.setHost(address.getHostAddress(), ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT));
        hostConfig.getParams().setParameter("http.virtual-host", (Object)ParameterMap.getKeyedString(map, (String)"virtual-host", null));
        if (ParameterMap.getKeyedBoolean(map, (String)"http-1.0", (boolean)false)) {
            httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        }
        for (String okey : map.keySet()) {
            String key = okey.toString();
            if (!key.matches("header_[0-9]+$")) continue;
            String headerName = ParameterMap.getKeyedString(map, (String)key, null);
            String headerValue = ParameterMap.getKeyedString(map, (String)(key + "_value"), null);
            getMethod.setRequestHeader(headerName, headerValue);
        }
        if (ParameterMap.getKeyedBoolean(map, (String)"auth-enabled", (boolean)false)) {
            httpClient.getParams().setAuthenticationPreemptive(ParameterMap.getKeyedBoolean(map, (String)"auth-preemptive", (boolean)true));
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ParameterMap.getKeyedString(map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString(map, (String)"auth-password", (String)DEFAULT_PASSWORD)));
        }
        try {
            httpClient.executeMethod(hostConfig, (HttpMethod)getMethod);
            Integer statusCode = getMethod.getStatusCode();
            String expectedText = ParameterMap.getKeyedString(map, (String)"response-text", null);
            retval = this.inRange(ParameterMap.getKeyedString(map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode);
            if (expectedText != null) {
                String responseText = getMethod.getResponseBodyAsString();
                retval = expectedText.charAt(0) == '~' ? responseText.matches(expectedText.substring(1)) : responseText.equals(expectedText);
            }
        }
        catch (HttpException e) {
            Log.info((Object)((Object)e));
            retval = false;
        }
        catch (IOException e) {
            Log.info((Object)e);
            retval = false;
        }
        finally {
            getMethod.releaseConnection();
        }
        return retval;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= new Integer(boundries[0]) && val <= new Integer(boundries[1]);
    }
}

