/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.utils.ExecRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "GP";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    private boolean isServer(InetAddress host, int retry, int timeout, String script, String args, RE regex, StringBuffer bannerResult, String hoption, String toption) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        log.debug("poll: address = " + host.getHostAddress() + ", script = " + script + ", arguments = " + args + ", timeout(seconds) = " + timeout + ", retry = " + retry);
        for (int attempts = 0; attempts <= retry && !isAServer; ++attempts) {
            try {
                int exitStatus = 100;
                ExecRunner er = new ExecRunner();
                er.setMaxRunTimeSecs(timeout);
                exitStatus = args == null ? er.exec(script + " " + hoption + " " + host.getHostAddress() + " " + toption + " " + timeout) : er.exec(script + " " + hoption + " " + host.getHostAddress() + " " + toption + " " + timeout + " " + args);
                if (exitStatus != 0) {
                    log.debug(script + " failed with exit code " + exitStatus);
                    isAServer = false;
                }
                if (er.isMaxRunTimeExceeded()) {
                    log.debug(script + " failed. Timeout exceeded");
                    isAServer = false;
                    continue;
                }
                if (exitStatus != 0) continue;
                String response = "";
                String error = "";
                response = er.getOutString();
                error = er.getErrString();
                if (response.equals("")) {
                    log.debug(script + " returned no output");
                }
                if (!error.equals("")) {
                    log.debug(script + " error = " + error);
                }
                if (regex == null || regex.match(response)) {
                    if (log.isDebugEnabled()) {
                        log.debug("isServer: matching response = " + response);
                    }
                    isAServer = true;
                    if (bannerResult == null) continue;
                    bannerResult.append(response);
                    continue;
                }
                isAServer = false;
                if (!log.isDebugEnabled()) continue;
                log.debug("isServer: NON-matching response = " + response);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                isAServer = false;
                e.fillInStackTrace();
                log.debug(script + " ArrayIndexOutOfBoundsException");
                continue;
            }
            catch (InterruptedIOException e) {
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                isAServer = false;
                e.fillInStackTrace();
                log.debug("IOException occurred. Check for proper operation of " + script);
                continue;
            }
            catch (Exception e) {
                isAServer = false;
                e.fillInStackTrace();
                log.debug(script + " Exception occurred");
            }
        }
        log.debug("poll: GP - isAServer = " + isAServer + "  " + host.getHostAddress());
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected GP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retry = 0;
        int timeout = 5000;
        String banner = null;
        String match = null;
        String script = null;
        String args = null;
        String hoption = "--hostname";
        String toption = "--timeout";
        if (qualifiers != null) {
            retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            script = ParameterMap.getKeyedString(qualifiers, (String)"script", null);
            args = ParameterMap.getKeyedString(qualifiers, (String)"args", null);
            banner = ParameterMap.getKeyedString(qualifiers, (String)"banner", null);
            match = ParameterMap.getKeyedString(qualifiers, (String)"match", null);
            hoption = ParameterMap.getKeyedString(qualifiers, (String)"hoption", (String)"--hostname");
            toption = ParameterMap.getKeyedString(qualifiers, (String)"toption", (String)"--timeout");
        }
        if (script == null) {
            throw new RuntimeException("GpPlugin: required parameter 'script' is not present in supplied properties.");
        }
        timeout = 0 < timeout && timeout < 1000 ? 1 : (timeout /= 1000);
        try {
            StringBuffer bannerResult = null;
            RE regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = new RE(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = new RE(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, retry, timeout, script, args, regex, bannerResult, hoption, toption);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (RESyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

