/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.model.events.StoppableEventListener;
import org.springframework.util.Assert;

public class Capsd
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Capsd";
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    private Scheduler m_scheduler = null;
    private StoppableEventListener m_eventListener;
    private RunnableConsumerThreadPool m_suspectRunner;
    private RunnableConsumerThreadPool m_rescanRunner;
    private SuspectEventProcessorFactory m_suspectEventProcessorFactory;
    private CapsdDbSyncer m_capsdDbSyncer;
    private CapsdConfig m_capsdConfig;

    public Capsd() {
        super(LOG4J_CATEGORY);
    }

    protected void onStop() {
        this.m_eventListener.stop();
        this.m_suspectRunner.stop();
        this.m_rescanRunner.stop();
    }

    protected void onInit() {
        Assert.state((this.m_suspectEventProcessorFactory != null ? 1 : 0) != 0, (String)"must set the suspectEventProcessorFactory property");
        Assert.state((this.m_capsdDbSyncer != null ? 1 : 0) != 0, (String)"must set the capsdDbSyncer property");
        Assert.state((this.m_capsdConfig != null ? 1 : 0) != 0, (String)"must set the capsdConfig property");
        Assert.state((this.m_suspectRunner != null ? 1 : 0) != 0, (String)"must set the suspectRunner property");
        Assert.state((this.m_rescanRunner != null ? 1 : 0) != 0, (String)"must set the rescanRunner property");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"must set the scheduler property");
        Assert.state((this.m_eventListener != null ? 1 : 0) != 0, (String)"must set the eventListener property");
        this.log().debug("init: Loading services into database...");
        this.getCapsdDbSyncer().syncServices();
        this.log().debug("init: Syncing management state...");
        this.getCapsdDbSyncer().syncManagementState();
        this.log().debug("init: Syncing primary SNMP interface state...");
        this.getCapsdDbSyncer().syncSnmpPrimaryState();
    }

    protected void onStart() {
        SuspectEventProcessor.setQueuedSuspectsTracker(new HashSet<String>());
        RescanProcessor.setQueuedRescansTracker(new HashSet<Integer>());
        this.log().debug("start: Starting runnable thread pools...");
        this.m_suspectRunner.start();
        this.m_rescanRunner.start();
        this.log().debug("start: Starting rescan scheduler");
        this.m_scheduler.start();
    }

    protected void onPause() {
    }

    protected void onResume() {
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanSuspectInterface(String ifAddr) throws UnknownHostException {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            InetAddress addr = InetAddress.getByName(ifAddr);
            SuspectEventProcessor proc = this.m_suspectEventProcessorFactory.createSuspectEventProcessor(addr.getHostAddress());
            proc.run();
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanInterfaceParent(Integer nodeId) {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.m_scheduler.forceRescan(nodeId);
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    private CapsdDbSyncer getCapsdDbSyncer() {
        return this.m_capsdDbSyncer;
    }

    public void setCapsdDbSyncer(CapsdDbSyncer capsdDbSyncer) {
        this.m_capsdDbSyncer = capsdDbSyncer;
    }

    public void setSuspectEventProcessorFactory(SuspectEventProcessorFactory eventProcessorFactory) {
        this.m_suspectEventProcessorFactory = eventProcessorFactory;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    public void setSuspectRunner(RunnableConsumerThreadPool suspectRunner) {
        this.m_suspectRunner = suspectRunner;
    }

    public void setRescanRunner(RunnableConsumerThreadPool rescanRunner) {
        this.m_rescanRunner = rescanRunner;
    }

    public void setEventListener(StoppableEventListener eventListener) {
        this.m_eventListener = eventListener;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    static {
        try {
            m_address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            m_address = "localhost";
            ThreadCategory.getInstance((String)LOG4J_CATEGORY).warn("Could not lookup the host name for the local host machine, address set to localhost", (Throwable)uhE);
        }
    }
}

