/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.agent.prometheus.Util;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricVisitor;

public class Histogram
extends Metric {
    private final long sampleCount;
    private final double sampleSum;
    private final List<Bucket> buckets;

    private Histogram(Builder builder) {
        super(builder);
        this.getLabels().remove("le");
        this.sampleCount = builder.sampleCount;
        this.sampleSum = builder.sampleSum;
        this.buckets = builder.buckets;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public double getSampleSum() {
        return this.sampleSum;
    }

    public List<Bucket> getBuckets() {
        if (this.buckets == null) {
            return Collections.emptyList();
        }
        return this.buckets;
    }

    @Override
    public void visit(MetricVisitor visitor) {
        visitor.visitHistogram(this);
    }

    public static class Bucket {
        private final double upperBound;
        private final long cumulativeCount;

        public Bucket(double upperBound, long cumulativeCount) {
            this.upperBound = upperBound;
            this.cumulativeCount = cumulativeCount;
        }

        public double getUpperBound() {
            return this.upperBound;
        }

        public long getCumulativeCount() {
            return this.cumulativeCount;
        }

        public String toString() {
            return String.format("%s:%d", Util.convertDoubleToString(this.upperBound), this.cumulativeCount);
        }
    }

    public static class Builder
    extends Metric.Builder<Builder> {
        private long sampleCount = 0L;
        private double sampleSum = Double.NaN;
        private List<Bucket> buckets;

        @Override
        public Histogram build() {
            return new Histogram(this);
        }

        public Builder setSampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public Builder setSampleSum(double sampleSum) {
            this.sampleSum = sampleSum;
            return this;
        }

        public Builder addBucket(double upperBound, long cumulativeCount) {
            if (this.buckets == null) {
                this.buckets = new ArrayList<Bucket>();
            }
            this.buckets.add(new Bucket(upperBound, cumulativeCount));
            return this;
        }

        public Builder addBuckets(List<Bucket> buckets) {
            if (this.buckets == null) {
                this.buckets = new ArrayList<Bucket>();
            }
            this.buckets.addAll(buckets);
            return this;
        }
    }
}

