/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.mibcompiler.services;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsmiparser.parser.SmiDefaultParser;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.problem.DefaultProblemReporterFactory;
import org.jsmiparser.util.problem.ProblemEvent;
import org.jsmiparser.util.problem.ProblemEventHandler;
import org.jsmiparser.util.problem.ProblemReporterFactory;
import org.jsmiparser.util.problem.annotations.ProblemSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsProblemEventHandler
implements ProblemEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsProblemEventHandler.class);
    private static final String FILE_PREFIX_LINUX = "file://";
    private static final String FILE_PREFIX_WINDOWS = "file:///";
    private static final Pattern DEPENDENCY_PATERN = Pattern.compile("Cannot find module ([^,]+)", 8);
    private int[] m_severityCounters = new int[ProblemSeverity.values().length];
    private int m_totalCounter;
    private ByteArrayOutputStream m_outputStream = new ByteArrayOutputStream();
    private PrintStream m_out = new PrintStream(this.m_outputStream);

    public OnmsProblemEventHandler(SmiDefaultParser parser) {
        DefaultProblemReporterFactory problemReporterFactory = new DefaultProblemReporterFactory(this.getClass().getClassLoader(), (ProblemEventHandler)this);
        parser.setProblemReporterFactory((ProblemReporterFactory)problemReporterFactory);
    }

    public void handle(ProblemEvent event) {
        int n = event.getSeverity().ordinal();
        this.m_severityCounters[n] = this.m_severityCounters[n] + 1;
        ++this.m_totalCounter;
        this.print(this.m_out, event.getSeverity().toString(), event.getLocation(), event.getLocalizedMessage());
    }

    public boolean isOk() {
        for (int i = 0; i < this.m_severityCounters.length; ++i) {
            int severityCounter;
            if (i < ProblemSeverity.ERROR.ordinal() || (severityCounter = this.m_severityCounters[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNotOk() {
        return !this.isOk();
    }

    public int getSeverityCount(ProblemSeverity severity) {
        return this.m_severityCounters[severity.ordinal()];
    }

    public int getTotalCount() {
        return this.m_totalCounter;
    }

    private String getPrefix() {
        return File.separatorChar == '\\' ? FILE_PREFIX_WINDOWS : FILE_PREFIX_LINUX;
    }

    private String getMibFromSource(String source) {
        return source.split(":")[File.separatorChar == '\\' ? 4 : 3];
    }

    private void print(PrintStream stream, String severity, Location location, String localizedMessage) {
        LOG.debug("[{}] Location: {}, Message: {}", new Object[]{severity, location, localizedMessage});
        int n = localizedMessage.indexOf(this.getPrefix());
        if (n > 0) {
            String source = localizedMessage.substring(n).replaceAll(this.getPrefix(), "");
            String message = localizedMessage.substring(0, n) + this.getMibFromSource(source);
            this.processMessage(stream, severity, source, message);
        } else if (location == null) {
            stream.println(severity + ": " + localizedMessage);
        } else {
            String source = location.toString().replaceAll(this.getPrefix(), "");
            String message = localizedMessage;
            this.processMessage(stream, severity, source, message);
        }
    }

    private Source getSourceData(String strSource) {
        String[] data = strSource.split(":");
        Source src = new Source();
        int rowIdx = 1;
        int colIdx = 2;
        if (File.separatorChar == '\\') {
            src.file = new File(data[0] + ':' + data[1]);
            rowIdx = 2;
            colIdx = 3;
        } else {
            src.file = new File(data[0]);
        }
        try {
            src.row = Integer.parseInt(data[rowIdx]);
        }
        catch (Exception e) {
            src.row = -1;
        }
        try {
            src.column = Integer.parseInt(data[colIdx]);
        }
        catch (Exception e) {
            src.column = -1;
        }
        return src;
    }

    private void processMessage(PrintStream stream, String severity, String source, String message) {
        Source src = this.getSourceData(source);
        stream.println(severity + ": " + message + ", Source: " + src.file.getName() + ", Row: " + src.row + ", Col: " + src.column);
        try {
            if (!src.file.exists()) {
                LOG.warn("File {} doesn't exist", (Object)src.file);
                return;
            }
            FileInputStream fs = new FileInputStream(src.file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fs));
            for (int i = 1; i < src.row; ++i) {
                br.readLine();
            }
            stream.println(br.readLine());
            br.close();
            stream.println(String.format("%" + src.column + "s", "^"));
        }
        catch (Exception e) {
            LOG.warn("Can't retrieve line {} from file {}", (Object)src.row, (Object)src.file);
        }
    }

    public void reset() {
        this.m_outputStream.reset();
        this.m_severityCounters = new int[ProblemSeverity.values().length];
        this.m_totalCounter = 0;
    }

    public List<String> getDependencies() {
        ArrayList<String> dependencies = new ArrayList<String>();
        if (this.m_outputStream.size() > 0) {
            Matcher m = DEPENDENCY_PATERN.matcher(this.m_outputStream.toString());
            while (m.find()) {
                String dep = m.group(1);
                if (dependencies.contains(dep)) continue;
                dependencies.add(dep);
            }
        }
        return dependencies;
    }

    public String getMessages() {
        return this.m_outputStream.size() > 0 ? this.m_outputStream.toString() : null;
    }

    public void addError(String errorMessage) {
        this.m_out.println(errorMessage);
    }

    private static class Source {
        public File file;
        public int row;
        public int column;

        private Source() {
        }
    }
}

