/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.serviceregistration.strategies;

import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.TXTRecord;
import java.util.Map;
import org.opennms.serviceregistration.ServiceRegistrationStrategy;

public class AppleStrategy
implements ServiceRegistrationStrategy,
RegisterListener {
    private boolean m_registered = false;
    private DNSSDRegistration m_registration;
    private String m_serviceType;
    private String m_serviceName;
    private int m_port;
    private Map<String, String> m_properties;

    @Override
    public void initialize(String serviceType, String serviceName, int port) throws Exception {
        this.initialize(serviceType, serviceName, port, null);
    }

    @Override
    public void initialize(String serviceType, String serviceName, int port, Map<String, String> properties) throws Exception {
        if (this.m_registered) {
            throw new Exception("You have already m_registered a service with this object!");
        }
        this.m_serviceType = "_" + serviceType.toLowerCase() + "._tcp";
        this.m_serviceName = serviceName;
        this.m_port = port;
        this.m_properties = properties;
    }

    @Override
    public void register() throws Exception {
        if (!this.m_registered) {
            TXTRecord txt = new TXTRecord();
            if (this.m_properties != null) {
                for (String key : this.m_properties.keySet()) {
                    txt.set(key, this.m_properties.get(key));
                }
            }
            DNSSD.register((int)0, (int)0, (String)this.m_serviceName, (String)this.m_serviceType, null, null, (int)this.m_port, (TXTRecord)txt, (RegisterListener)this);
        } else {
            System.err.println("WARNING: register() called but the service has already been m_registered!");
        }
    }

    @Override
    public void unregister() throws Exception {
        if (this.m_registered) {
            if (this.m_registration != null) {
                this.m_registration.stop();
                this.m_registration = null;
            } else {
                System.err.println("WARNING: unregister() has been called, but m_registration previously failed.");
            }
        } else {
            System.err.println("WARNING: unregister() called but no service has been m_registered.");
        }
    }

    public void serviceRegistered(DNSSDRegistration registration, int flags, String serviceName, String regType, String domain) {
        this.m_registration = registration;
        this.m_registered = true;
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        this.m_registered = false;
        System.err.println("m_registration failed for service '" + service + "' with error code '" + errorCode + "'");
    }
}

