/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.serviceregistration.strategies;

import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.opennms.serviceregistration.ServiceRegistrationStrategy;

public class JMDNSStrategy
implements ServiceRegistrationStrategy {
    private boolean m_registered = false;
    private JmDNS m_jmdns;
    private ServiceInfo m_si;

    @Override
    public void initialize(String serviceType, String serviceName, int port) throws Exception {
        this.initialize(serviceType, serviceName, port, null);
    }

    @Override
    public void initialize(String serviceType, String serviceName, int port, Map<String, String> properties) throws Exception {
        if (this.m_registered) {
            throw new Exception("You have already m_registered a service with this object!");
        }
        String serviceTypeName = "_" + serviceType.toLowerCase() + "._tcp.local.";
        this.m_jmdns = JmDNS.create();
        this.m_si = ServiceInfo.create((String)serviceTypeName, (String)serviceName, (int)port, (int)0, (int)0, properties);
    }

    @Override
    public void register() throws Exception {
        if (!this.m_registered) {
            this.m_jmdns.registerService(this.m_si);
            this.m_registered = true;
        } else {
            System.err.println("WARNING: register() called but the service has already been m_registered!");
        }
    }

    @Override
    public void unregister() throws Exception {
        if (this.m_registered) {
            if (this.m_jmdns != null && this.m_si != null) {
                this.m_jmdns.unregisterService(this.m_si);
                this.m_jmdns.close();
                this.m_registered = false;
            } else {
                System.err.println("WARNING: unregister() has been called, but registration previously failed.");
            }
        } else {
            System.err.println("WARNING: unregister() called but no service has been m_registered.");
        }
    }
}

