/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.tca.TcaCollectionHandler;
import org.opennms.netmgt.collectd.tca.dao.TcaDataCollectionConfigDao;
import org.opennms.netmgt.collection.api.AbstractServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcaCollector
extends AbstractServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(TcaCollector.class);
    private TcaDataCollectionConfigDao m_configDao;
    private ResourceStorageDao m_resourceStorageDao;
    private ResourceTypesDao m_resourceTypesDao;
    private LocationAwareSnmpClient m_locationAwareSnmpClient;

    public void initialize() throws CollectionInitializationException {
        LOG.debug("initialize: initializing TCA collector");
        if (this.m_configDao == null) {
            this.m_configDao = (TcaDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"tcaDataCollectionConfigDao", TcaDataCollectionConfigDao.class);
        }
        if (this.m_resourceStorageDao == null) {
            this.m_resourceStorageDao = (ResourceStorageDao)BeanUtils.getBean((String)"daoContext", (String)"resourceStorageDao", ResourceStorageDao.class);
        }
        if (this.m_resourceTypesDao == null) {
            this.m_resourceTypesDao = (ResourceTypesDao)BeanUtils.getBean((String)"daoContext", (String)"resourceTypesDao", ResourceTypesDao.class);
        }
        if (this.m_locationAwareSnmpClient == null) {
            this.m_locationAwareSnmpClient = (LocationAwareSnmpClient)BeanUtils.getBean((String)"daoContext", (String)"locationAwareSnmpClient", LocationAwareSnmpClient.class);
        }
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"tca-collection", null);
            }
            if (collectionName == null) {
                throw new CollectionException("Parameter collection is required for the TCA Collector!");
            }
            TcaCollectionHandler collectionHandler = new TcaCollectionHandler((SnmpCollectionAgent)agent, this.getRrdRepository(collectionName), this.m_resourceStorageDao, this.m_resourceTypesDao, this.m_locationAwareSnmpClient);
            return collectionHandler.collect();
        }
        catch (CollectionException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error("Unexpected error during node TCA collection for: {}", (Object)agent.getHostAddress(), (Object)t);
            throw new CollectionException("Unexpected error during node TCA collection for: " + agent.getHostAddress() + ": " + t, t);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_configDao.getConfig().buildRrdRepository(collectionName);
    }

    public TcaDataCollectionConfigDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(TcaDataCollectionConfigDao configDao) {
        this.m_configDao = configDao;
    }

    public ResourceStorageDao getResourceStorageDao() {
        return this.m_resourceStorageDao;
    }

    public void setResourceStorageDao(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
    }

    public void setResourceTypesDao(ResourceTypesDao resourceTypesDao) {
        this.m_resourceTypesDao = resourceTypesDao;
    }

    public void setLocationAwareSnmpClient(LocationAwareSnmpClient locationAwareSnmpClient) {
        this.m_locationAwareSnmpClient = locationAwareSnmpClient;
    }
}

