/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.core.rpc.api.RequestRejectedException;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.tca.TcaData;
import org.opennms.netmgt.collectd.tca.TcaDataEntry;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionUnknown;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcaCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TcaCollectionHandler.class);
    public static final String RESOURCE_TYPE_NAME = "juniperTcaEntry";
    public static final String LAST_TIMESTAMP = "__tcaLastTimestamp";
    public static final String INBOUND_DELAY = "inboundDelay";
    public static final String INBOUND_JITTER = "inboundJitter";
    public static final String OUTBOUND_DELAY = "outboundDelay";
    public static final String OUTBOUND_JITTER = "outboundJitter";
    public static final String TIMESYNC_STATUS = "timesyncStatus";
    private SnmpCollectionAgent m_agent;
    private final RrdRepository m_repository;
    private final ResourceStorageDao m_resourceStorageDao;
    private final ResourceType m_resourceType;
    private final LocationAwareSnmpClient m_locationAwareSnmpClient;

    public TcaCollectionHandler(SnmpCollectionAgent agent, RrdRepository repository, ResourceStorageDao resourceStorageDao, ResourceTypesDao resourceTypesDao, LocationAwareSnmpClient locationAwareSnmpClient) {
        this.m_agent = Objects.requireNonNull(agent);
        this.m_repository = Objects.requireNonNull(repository);
        this.m_resourceStorageDao = Objects.requireNonNull(resourceStorageDao);
        this.m_resourceType = Objects.requireNonNull(resourceTypesDao).getResourceTypeByName(RESOURCE_TYPE_NAME);
        if (this.m_resourceType == null) {
            throw new IllegalArgumentException("No resource of type juniperTcaEntry is defined.");
        }
        this.m_locationAwareSnmpClient = Objects.requireNonNull(locationAwareSnmpClient);
    }

    protected CollectionSet collect() throws CollectionException {
        try {
            CollectionSetBuilder builder = new CollectionSetBuilder((CollectionAgent)this.m_agent);
            TcaData tracker = new TcaData(this.m_agent.getAddress());
            CompletableFuture future = this.m_locationAwareSnmpClient.walk(this.m_agent.getAgentConfig(), (CollectionTracker)tracker).withDescription("TcaCollector for " + this.m_agent.getHostAddress()).withLocation(this.m_agent.getLocationName()).execute();
            LOG.debug("collect: successfully instantiated TCA Collector for {}", (Object)this.m_agent.getHostAddress());
            future.get();
            LOG.info("collect: node TCA query for address {} complete.", (Object)this.m_agent.getHostAddress());
            this.process(tracker, builder);
            return builder.build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CollectionUnknown("Collection of node TCA data for interface " + this.m_agent.getHostAddress() + " interrupted: " + e, (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof RequestTimedOutException) {
                throw new CollectionUnknown(String.format("No response received when remotely collecting TCA data for interface %s at location %s interrupted.", this.m_agent.getHostAddress(), this.m_agent.getLocationName()), (Throwable)e);
            }
            if (cause != null && cause instanceof RequestRejectedException) {
                throw new CollectionUnknown(String.format("The request to remotely collect TCA data for interface %s at location %s was rejected.", this.m_agent.getHostAddress(), this.m_agent.getLocationName()), (Throwable)e);
            }
            throw new CollectionException(String.format("Unexpected exception when collecting TCA data for interface %s at location %s.", this.m_agent.getHostAddress(), this.m_agent.getLocationName()), (Throwable)e);
        }
    }

    private void process(TcaData tracker, CollectionSetBuilder builder) {
        LOG.debug("process: processing raw TCA data for {} peers.", (Object)tracker.size());
        NodeLevelResource nodeResource = new NodeLevelResource(this.m_agent.getNodeId());
        long timestamp = 0L;
        for (TcaDataEntry entry : tracker.getEntries()) {
            GenericTypeResource resource = new GenericTypeResource(nodeResource, (org.opennms.netmgt.collection.api.ResourceType)this.m_resourceType, entry.getPeerAddress());
            AbstractCollectionResource collectionResource = CollectionSetBuilder.toCollectionResource((Resource)resource, (CollectionAgent)this.m_agent);
            long lastTimestamp = this.getLastTimestamp((CollectionResource)collectionResource);
            String[] rawData = entry.getRawData().split("\\|");
            int samples = Integer.parseInt(rawData[1]);
            SnmpObjId entryObjId = SnmpObjId.get((String)".1.3.6.1.4.1.27091.3.1.6.1.2", (String)entry.getInstance().toString());
            String identifierPrefix = String.format("TCA_%s_", entryObjId);
            for (int i = 0; i < samples; ++i) {
                LOG.debug("process: processing row {}: {}", (Object)i, (Object)rawData[2 + i]);
                String[] rawEntry = rawData[2 + i].split(",");
                timestamp = Long.parseLong(rawEntry[0]);
                if (timestamp > lastTimestamp) {
                    resource = new GenericTypeResource(nodeResource, (org.opennms.netmgt.collection.api.ResourceType)this.m_resourceType, entry.getPeerAddress());
                    resource.setTimestamp(new Date(timestamp * 1000L));
                    builder.withIdentifiedNumericAttribute((Resource)resource, RESOURCE_TYPE_NAME, INBOUND_DELAY, (Number)Double.parseDouble(rawEntry[1]), AttributeType.GAUGE, identifierPrefix + INBOUND_DELAY);
                    builder.withIdentifiedNumericAttribute((Resource)resource, RESOURCE_TYPE_NAME, INBOUND_JITTER, (Number)Double.parseDouble(rawEntry[2]), AttributeType.GAUGE, identifierPrefix + INBOUND_JITTER);
                    builder.withIdentifiedNumericAttribute((Resource)resource, RESOURCE_TYPE_NAME, OUTBOUND_DELAY, (Number)Double.parseDouble(rawEntry[3]), AttributeType.GAUGE, identifierPrefix + OUTBOUND_DELAY);
                    builder.withIdentifiedNumericAttribute((Resource)resource, RESOURCE_TYPE_NAME, OUTBOUND_JITTER, (Number)Double.parseDouble(rawEntry[4]), AttributeType.GAUGE, identifierPrefix + OUTBOUND_JITTER);
                    builder.withIdentifiedNumericAttribute((Resource)resource, RESOURCE_TYPE_NAME, TIMESYNC_STATUS, (Number)Double.parseDouble(rawEntry[5]), AttributeType.GAUGE, identifierPrefix + TIMESYNC_STATUS);
                    continue;
                }
                LOG.debug("process: skipping row {} {} because it was already processed.", (Object)i, (Object)rawData[2 + i]);
            }
            this.setLastTimestamp((CollectionResource)collectionResource, timestamp);
        }
    }

    private long getLastTimestamp(CollectionResource resource) {
        long timestamp = 0L;
        ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.m_repository, (ResourcePath)resource.getPath());
        try {
            LOG.debug("Retrieving timestamp from path {}", (Object)path);
            String ts = this.m_resourceStorageDao.getStringAttribute(path, LAST_TIMESTAMP);
            if (ts != null) {
                timestamp = Long.parseLong(ts);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve timestamp from path {}", (Object)path, (Object)e);
        }
        return timestamp;
    }

    private void setLastTimestamp(CollectionResource resource, long timestamp) {
        ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.m_repository, (ResourcePath)resource.getPath());
        LOG.debug("Setting timestamp to {} at path {}", (Object)timestamp, (Object)path);
        this.m_resourceStorageDao.setStringAttribute(path, LAST_TIMESTAMP, Long.toString(timestamp));
    }
}

