/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.collectd.CollectionTimedOut;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.tca.TcaCollectionAttributeType;
import org.opennms.netmgt.collectd.tca.TcaCollectionResource;
import org.opennms.netmgt.collectd.tca.TcaData;
import org.opennms.netmgt.collectd.tca.TcaDataEntry;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.AbstractCollectionSet;
import org.opennms.netmgt.collection.support.ConstantTimeKeeper;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcaCollectionSet
extends AbstractCollectionSet {
    private static final Logger LOG = LoggerFactory.getLogger(TcaCollectionSet.class);
    public static final String LAST_TIMESTAMP = "__tcaLastTimestamp";
    public static final String INBOUND_DELAY = "inboundDelay";
    public static final String INBOUND_JITTER = "inboundJitter";
    public static final String OUTBOUND_DELAY = "outboundDelay";
    public static final String OUTBOUND_JITTER = "outboundJitter";
    public static final String TIMESYNC_STATUS = "timesyncStatus";
    private int m_status = 2;
    private List<TcaCollectionResource> m_collectionResources = new ArrayList<TcaCollectionResource>();
    private Date m_timestamp;
    private SnmpCollectionAgent m_agent;
    private final RrdRepository m_repository;
    private final ResourceStorageDao m_resourceStorageDao;

    public TcaCollectionSet(SnmpCollectionAgent agent, RrdRepository repository, ResourceStorageDao resourceStorageDao) {
        this.m_agent = agent;
        this.m_repository = repository;
        this.m_resourceStorageDao = resourceStorageDao;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet((CollectionSet)this);
        for (CollectionResource collectionResource : this.m_collectionResources) {
            collectionResource.visit(visitor);
        }
        visitor.completeCollectionSet((CollectionSet)this);
    }

    public Date getCollectionTimestamp() {
        return this.m_timestamp;
    }

    public void setCollectionTimestamp(Date date) {
        this.m_timestamp = date;
    }

    protected void collect() throws CollectionException {
        try {
            TcaData tracker = new TcaData((InetAddress)this.m_agent.getAddress());
            try (SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agent.getAgentConfig(), (String)("TcaCollector for " + this.m_agent.getHostAddress()), (CollectionTracker)tracker);){
                walker.start();
                LOG.debug("collect: successfully instantiated TCA Collector for {}", (Object)this.m_agent.getHostAddress());
                walker.waitFor();
                LOG.info("collect: node TCA query for address {} complete.", (Object)this.m_agent.getHostAddress());
                this.verifySuccessfulWalk(walker);
            }
            this.process(tracker);
            this.m_status = 1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CollectionWarning("Collection of node TCA data for interface " + this.m_agent.getHostAddress() + " interrupted: " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new CollectionException("Can't collect TCA data because " + e.getMessage(), (Throwable)e);
        }
    }

    protected List<TcaCollectionResource> getCollectionResources() {
        return this.m_collectionResources;
    }

    private void process(TcaData tracker) throws Exception {
        LOG.debug("process: processing raw TCA data for {} peers.", (Object)tracker.size());
        AttributeGroupType attribGroupType = new AttributeGroupType("juniperTcaEntry", "all");
        long timestamp = 0L;
        for (TcaDataEntry entry : tracker.getEntries()) {
            long lastTimestamp = this.getLastTimestamp(new TcaCollectionResource((CollectionAgent)this.m_agent, entry.getPeerAddress()));
            String[] rawData = entry.getRawData().split("\\|");
            int samples = Integer.parseInt(rawData[1]);
            SnmpObjId entryObjId = SnmpObjId.get((String)".1.3.6.1.4.1.27091.3.1.6.1.2", (String)entry.getInstance().toString());
            for (int i = 0; i < samples; ++i) {
                LOG.debug("process: processing row {}: {}", (Object)i, (Object)rawData[2 + i]);
                String[] rawEntry = rawData[2 + i].split(",");
                timestamp = Long.parseLong(rawEntry[0]);
                if (timestamp > lastTimestamp) {
                    TcaCollectionResource resource = new TcaCollectionResource((CollectionAgent)this.m_agent, entry.getPeerAddress());
                    resource.setTimeKeeper((TimeKeeper)new ConstantTimeKeeper(new Date(timestamp * 1000L)));
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, INBOUND_DELAY), rawEntry[1]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, INBOUND_JITTER), rawEntry[2]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, OUTBOUND_DELAY), rawEntry[3]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, OUTBOUND_JITTER), rawEntry[4]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, TIMESYNC_STATUS), rawEntry[5]);
                    this.m_collectionResources.add(resource);
                    continue;
                }
                LOG.debug("process: skipping row {} {} because it was already processed.", (Object)i, (Object)rawData[2 + i]);
            }
            this.setLastTimestamp(new TcaCollectionResource((CollectionAgent)this.m_agent, entry.getPeerAddress()), timestamp);
        }
    }

    private void verifySuccessfulWalk(SnmpWalker walker) throws CollectionException {
        if (!walker.failed()) {
            return;
        }
        if (walker.timedOut()) {
            throw new CollectionTimedOut(walker.getErrorMessage());
        }
        String message = "collection failed for " + this.m_agent.getHostAddress() + " due to: " + walker.getErrorMessage();
        throw new CollectionWarning(message, walker.getErrorThrowable());
    }

    private long getLastTimestamp(TcaCollectionResource resource) throws Exception {
        Object file = null;
        long timestamp = 0L;
        try {
            ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.m_repository, (Path)resource.getPath());
            String ts = this.m_resourceStorageDao.getStringAttribute(path, LAST_TIMESTAMP);
            if (ts != null) {
                timestamp = Long.parseLong(ts);
            }
        }
        catch (Exception e) {
            LOG.info("getLastFilename: creating a new filename tracker on {}", file);
        }
        return timestamp;
    }

    private void setLastTimestamp(TcaCollectionResource resource, long timestamp) throws Exception {
        ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.m_repository, (Path)resource.getPath());
        this.m_resourceStorageDao.setStringAttribute(path, LAST_TIMESTAMP, Long.toString(timestamp));
    }
}

