/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.tca.TcaCollectionSet;
import org.opennms.netmgt.collectd.tca.dao.TcaDataCollectionConfigDao;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcaCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(TcaCollector.class);
    private TcaDataCollectionConfigDao m_configDao;
    private ResourceStorageDao m_resourceStorageDao;

    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        LOG.debug("initialize: initializing TCA collector");
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException e) {
            LOG.error("initSnmpPeerFactory: Failed to load SNMP configuration: {}", (Object)e, (Object)e);
            throw new UndeclaredThrowableException(e);
        }
        if (this.m_configDao == null) {
            this.m_configDao = (TcaDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"tcaDataCollectionConfigDao", TcaDataCollectionConfigDao.class);
        }
        if (this.m_resourceStorageDao == null) {
            this.m_resourceStorageDao = (ResourceStorageDao)BeanUtils.getBean((String)"daoContext", (String)"resourceStorageDao", ResourceStorageDao.class);
        }
        LOG.debug("initialize: Initializing RRD repo from XmlCollector...");
        File f = new File(this.m_configDao.getConfig().getRrdRepository());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new CollectionInitializationException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_configDao.getConfig().getRrdRepository());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        LOG.debug("initialize: initializing TCA collection handling using {} for collection agent {}", parameters, (Object)agent);
    }

    public void release() {
        LOG.debug("release: realeasing TCA collection");
    }

    public void release(CollectionAgent agent) {
        LOG.debug("release: realeasing TCA collection for agent {}", (Object)agent);
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"tca-collection", null);
            }
            if (collectionName == null) {
                throw new CollectionException("Parameter collection is required for the TCA Collector!");
            }
            TcaCollectionSet collectionSet = new TcaCollectionSet((SnmpCollectionAgent)agent, this.getRrdRepository(collectionName), this.m_resourceStorageDao);
            collectionSet.setCollectionTimestamp(new Date());
            collectionSet.collect();
            return collectionSet;
        }
        catch (Throwable t) {
            throw new CollectionException("Unexpected error during node TCA collection for: " + agent.getHostAddress() + ": " + t, t);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_configDao.getConfig().buildRrdRepository(collectionName);
    }

    public TcaDataCollectionConfigDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(TcaDataCollectionConfigDao configDao) {
        this.m_configDao = configDao;
    }

    public ResourceStorageDao getResourceStorageDao() {
        return this.m_resourceStorageDao;
    }

    public void setResourceStorageDao(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
    }
}

