/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.nio.file.Path;
import org.opennms.netmgt.collectd.tca.TcaCollectionAttribute;
import org.opennms.netmgt.collectd.tca.TcaCollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;

public class TcaCollectionResource
extends AbstractCollectionResource {
    public static final String RESOURCE_TYPE_NAME = "juniperTcaEntry";
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();
    private final String m_peerAddress;
    private final StorageStrategy m_strategy;

    protected TcaCollectionResource(CollectionAgent agent, String peerAddress) {
        super(agent);
        this.m_peerAddress = peerAddress;
        this.m_strategy = new IndexStorageStrategy();
        this.m_strategy.setResourceTypeName(RESOURCE_TYPE_NAME);
    }

    public String getResourceTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public String getInstance() {
        return this.m_peerAddress;
    }

    public String getInterfaceLabel() {
        return this.m_peerAddress;
    }

    public String toString() {
        return "node[" + this.m_agent.getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getInterfaceLabel() + "]";
    }

    public Path getPath() {
        return this.m_strategy.getRelativePathForAttribute(this.getParent(), this.getInterfaceLabel());
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    public void setAttributeValue(TcaCollectionAttributeType type, String value) {
        TcaCollectionAttribute attr = new TcaCollectionAttribute(this, type, value);
        this.addAttribute((CollectionAttribute)attr);
    }
}

