/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import org.opennms.netmgt.collectd.tca.TcaCollectionAttributeType;
import org.opennms.netmgt.collectd.tca.TcaCollectionResource;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;

public class TcaCollectionAttribute
extends AbstractCollectionAttribute {
    private final String m_value;

    public TcaCollectionAttribute(TcaCollectionResource resource, TcaCollectionAttributeType attribType, String value) {
        super((CollectionAttributeType)attribType, (CollectionResource)resource);
        this.m_value = value;
    }

    public Double getNumericValue() {
        try {
            return Double.parseDouble(this.m_value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    public String getStringValue() {
        return this.m_value;
    }

    public String toString() {
        return "TcaCollectionAttribute " + this.getName() + "=" + this.m_value;
    }

    public String getMetricIdentifier() {
        return "TCA_" + ((TcaCollectionAttributeType)this.m_attribType).getAttributeObjectId() + '_' + this.getName();
    }
}

