/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.CollectionTimedOut;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.tca.ConstantTimeKeeper;
import org.opennms.netmgt.collectd.tca.TcaCollectionAttributeType;
import org.opennms.netmgt.collectd.tca.TcaCollectionResource;
import org.opennms.netmgt.collectd.tca.TcaData;
import org.opennms.netmgt.collectd.tca.TcaDataEntry;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public class TcaCollectionSet
implements CollectionSet {
    public static final String LAST_TIMESTAMP = "__tcaLastTimestamp";
    public static final String INBOUND_DELAY = "inboundDelay";
    public static final String INBOUND_JITTER = "inboundJitter";
    public static final String OUTBOUND_DELAY = "outboundDelay";
    public static final String OUTBOUND_JITTER = "outboundJitter";
    public static final String TIMESYNC_STATUS = "timesyncStatus";
    private int m_status = 2;
    private List<TcaCollectionResource> m_collectionResources = new ArrayList<TcaCollectionResource>();
    private Date m_timestamp;
    private CollectionAgent m_agent;
    private RrdRepository m_rrdRepository;

    public TcaCollectionSet(CollectionAgent agent, RrdRepository repository) {
        this.m_agent = agent;
        this.m_rrdRepository = repository;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet((CollectionSet)this);
        for (TcaCollectionResource resource : this.m_collectionResources) {
            resource.visit(visitor);
        }
        visitor.completeCollectionSet((CollectionSet)this);
    }

    public boolean ignorePersist() {
        return false;
    }

    public Date getCollectionTimestamp() {
        return this.m_timestamp;
    }

    public void setCollectionTimestamp(Date date) {
        this.m_timestamp = date;
    }

    protected void collect() throws CollectionException {
        try {
            TcaData tracker = new TcaData(this.m_agent.getInetAddress());
            SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agent.getAgentConfig(), (String)("TcaCollector for " + this.m_agent.getHostAddress()), (CollectionTracker)tracker);
            walker.start();
            this.log().debug("collect: successfully instantiated TCA Collector for " + this.m_agent.getHostAddress());
            walker.waitFor();
            this.log().info("collect: node TCA query for address " + this.m_agent.getHostAddress() + " complete.");
            this.verifySuccessfulWalk(walker);
            this.process(tracker);
            this.m_status = 1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CollectionWarning("Collection of node TCA data for interface " + this.m_agent.getHostAddress() + " interrupted: " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new CollectionException("Can't collect TCA data because " + e.getMessage(), (Throwable)e);
        }
    }

    protected List<TcaCollectionResource> getCollectionResources() {
        return this.m_collectionResources;
    }

    private void process(TcaData tracker) throws Exception {
        this.log().debug("process: processing raw TCA data for " + tracker.size() + " peers.");
        AttributeGroupType attribGroupType = new AttributeGroupType("juniperTcaEntry", "all");
        long timestamp = 0L;
        for (TcaDataEntry entry : tracker.getEntries()) {
            long lastTimestamp = this.getLastTimestamp(new TcaCollectionResource(this.m_agent, entry.getPeerAddress()));
            String[] rawData = entry.getRawData().split("\\|");
            int samples = Integer.parseInt(rawData[1]);
            SnmpObjId entryObjId = SnmpObjId.get((String)".1.3.6.1.4.1.27091.3.1.6.1.2", (String)entry.getInstance().toString());
            for (int i = 0; i < samples; ++i) {
                this.log().debug("process: processing row " + i + ": " + rawData[2 + i]);
                String[] rawEntry = rawData[2 + i].split(",");
                timestamp = Long.parseLong(rawEntry[0]);
                if (timestamp > lastTimestamp) {
                    TcaCollectionResource resource = new TcaCollectionResource(this.m_agent, entry.getPeerAddress());
                    resource.setTimeKeeper(new ConstantTimeKeeper(timestamp));
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, INBOUND_DELAY), rawEntry[1]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, INBOUND_JITTER), rawEntry[2]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, OUTBOUND_DELAY), rawEntry[3]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, OUTBOUND_JITTER), rawEntry[4]);
                    resource.setAttributeValue(new TcaCollectionAttributeType(attribGroupType, entryObjId, TIMESYNC_STATUS), rawEntry[5]);
                    this.m_collectionResources.add(resource);
                    continue;
                }
                this.log().debug("process: skipping row " + i + " " + rawData[2 + i] + " because it was already processed.");
            }
            this.setLastTimestamp(new TcaCollectionResource(this.m_agent, entry.getPeerAddress()), timestamp);
        }
    }

    private void verifySuccessfulWalk(SnmpWalker walker) throws CollectionException {
        if (!walker.failed()) {
            return;
        }
        if (walker.timedOut()) {
            throw new CollectionTimedOut(walker.getErrorMessage());
        }
        String message = "collection failed for " + this.m_agent.getHostAddress() + " due to: " + walker.getErrorMessage();
        throw new CollectionWarning(message, walker.getErrorThrowable());
    }

    private long getLastTimestamp(TcaCollectionResource resource) throws Exception {
        File file = null;
        long timestamp = 0L;
        try {
            file = resource.getResourceDir(this.m_rrdRepository);
            String ts = ResourceTypeUtils.getStringProperty((File)resource.getResourceDir(this.m_rrdRepository), (String)LAST_TIMESTAMP);
            if (ts != null) {
                timestamp = Long.parseLong(ts);
            }
        }
        catch (Exception e) {
            this.log().info("getLastFilename: creating a new filename tracker on " + file);
        }
        return timestamp;
    }

    private void setLastTimestamp(TcaCollectionResource resource, long timestamp) throws Exception {
        ResourceTypeUtils.updateStringProperty((File)resource.getResourceDir(this.m_rrdRepository), (String)Long.toString(timestamp), (String)LAST_TIMESTAMP);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

