/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.Map;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.tca.TcaCollectionSet;
import org.opennms.netmgt.collectd.tca.dao.TcaDataCollectionConfigDao;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;

public class TcaCollector
implements ServiceCollector {
    private String m_serviceName;
    private TcaDataCollectionConfigDao m_configDao;

    public TcaDataCollectionConfigDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(TcaDataCollectionConfigDao configDao) {
        this.m_configDao = configDao;
    }

    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        this.log().debug("initialize: initializing TCA collector");
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException e) {
            this.log().fatal("initSnmpPeerFactory: Failed to load SNMP configuration: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        if (this.m_configDao == null) {
            this.m_configDao = (TcaDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"tcaDataCollectionConfigDao", TcaDataCollectionConfigDao.class);
        }
        this.log().debug("initialize: Initializing RRD repo from XmlCollector...");
        File f = new File(this.m_configDao.getConfig().getRrdRepository());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new CollectionInitializationException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_configDao.getConfig().getRrdRepository());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        this.log().debug("initialize: initializing TCA collection handling using " + parameters + " for collection agent " + agent);
        this.m_serviceName = ParameterMap.getKeyedString(parameters, (String)"SERVICE", (String)"TCA");
    }

    public void release() {
        this.log().debug("release: realeasing TCA collection");
    }

    public void release(CollectionAgent agent) {
        this.log().debug("release: realeasing TCA collection for agent " + agent);
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"tca-collection", null);
            }
            if (collectionName == null) {
                throw new CollectionException("Parameter collection is required for the TCA Collector!");
            }
            Collectd.instrumentation().beginCollectingServiceData(agent.getNodeId(), agent.getHostAddress(), this.m_serviceName);
            TcaCollectionSet collectionSet = new TcaCollectionSet(agent, this.getRrdRepository(collectionName));
            collectionSet.setCollectionTimestamp(new Date());
            collectionSet.collect();
            TcaCollectionSet tcaCollectionSet = collectionSet;
            return tcaCollectionSet;
        }
        catch (Throwable t) {
            CollectionException e = new CollectionException("Unexpected error during node TCA collection for: " + agent.getHostAddress() + ": " + t, t);
            Collectd.instrumentation().reportCollectionException(agent.getNodeId(), agent.getHostAddress(), this.m_serviceName, e);
            throw e;
        }
        finally {
            Collectd.instrumentation().endCollectingServiceData(agent.getNodeId(), agent.getHostAddress(), this.m_serviceName);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_configDao.getConfig().buildRrdRepository(collectionName);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

