/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca;

import java.io.File;
import org.opennms.core.utils.DefaultTimeKeeper;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.collectd.AbstractCollectionResource;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.tca.TcaCollectionAttribute;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.dao.support.IndexStorageStrategy;
import org.opennms.netmgt.model.RrdRepository;

public class TcaCollectionResource
extends AbstractCollectionResource {
    public static final String RESOURCE_TYPE_NAME = "juniperTcaEntry";
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();
    private String m_peerAddress;
    private StorageStrategy m_strategy;

    protected TcaCollectionResource(CollectionAgent agent, String peerAddress) {
        super(agent);
        this.m_peerAddress = peerAddress;
        this.m_strategy = new IndexStorageStrategy();
        this.m_strategy.setResourceTypeName(RESOURCE_TYPE_NAME);
    }

    public String getResourceTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public String getParent() {
        return Integer.toString(this.m_agent.getNodeId());
    }

    public String getInstance() {
        return this.m_peerAddress;
    }

    public String getLabel() {
        return this.m_peerAddress;
    }

    public int getType() {
        return -1;
    }

    public boolean rescanNeeded() {
        return false;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String toString() {
        return "node[" + this.m_agent.getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getLabel() + "]";
    }

    public File getResourceDir(RrdRepository repository) {
        String resourcePath = this.m_strategy.getRelativePathForAttribute(this.getParent(), this.getLabel(), null);
        return new File(repository.getRrdBaseDir(), resourcePath);
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    public void setAttributeValue(CollectionAttributeType type, String value) {
        TcaCollectionAttribute attr = new TcaCollectionAttribute(this, type, type.getName(), value);
        this.addAttribute(attr);
    }
}

