/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.tca.config;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.collectd.tca.config.TcaDataCollection;
import org.opennms.netmgt.collectd.tca.config.TcaRrd;
import org.opennms.netmgt.model.RrdRepository;

@XmlRootElement(name="tca-datacollection-config")
public class TcaDataCollectionConfig
implements Serializable,
Comparable<TcaDataCollectionConfig> {
    private static final long serialVersionUID = 5432437490676491057L;
    public static final String TCA_DATACOLLECTION_CONFIG_FILE = "tca-datacollection-config.xml";
    @XmlAttribute(name="rrdRepository", required=true)
    private String m_rrdRepository;
    private static final TcaDataCollection[] OF_DATA_COLLECTIONS = new TcaDataCollection[0];
    @XmlElement(name="tca-collection")
    private List<TcaDataCollection> m_tcaDataCollections = new ArrayList<TcaDataCollection>();

    @XmlTransient
    public String getRrdRepository() {
        return this.m_rrdRepository;
    }

    public void setRrdRepository(String rrdRepository) {
        this.m_rrdRepository = rrdRepository;
    }

    @XmlTransient
    public List<TcaDataCollection> getTcaDataCollections() {
        return this.m_tcaDataCollections;
    }

    public void setTcaDataCollections(List<TcaDataCollection> tcaDataCollections) {
        this.m_tcaDataCollections = tcaDataCollections;
    }

    public void addDataCollection(TcaDataCollection dataCollection) {
        this.m_tcaDataCollections.add(dataCollection);
    }

    public void removeDataCollection(TcaDataCollection dataCollection) {
        this.m_tcaDataCollections.remove(dataCollection);
    }

    public void removeDataCollectionByName(String name) {
        for (TcaDataCollection dataCollection : this.m_tcaDataCollections) {
            if (!dataCollection.getName().equals(name)) continue;
            this.m_tcaDataCollections.remove(dataCollection);
            return;
        }
    }

    public TcaDataCollection getDataCollectionByName(String name) {
        for (TcaDataCollection dataCol : this.m_tcaDataCollections) {
            if (!dataCol.getName().equals(name)) continue;
            return dataCol;
        }
        return null;
    }

    public RrdRepository buildRrdRepository(String collectionName) {
        TcaDataCollection collection = this.getDataCollectionByName(collectionName);
        if (collection == null) {
            return null;
        }
        TcaRrd rrd = collection.getRrd();
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdRepository()));
        repo.setRraList(rrd.getRras());
        repo.setStep(rrd.getStep().intValue());
        repo.setHeartBeat(rrd.getStep().intValue());
        return repo;
    }

    @Override
    public int compareTo(TcaDataCollectionConfig obj) {
        return new CompareToBuilder().append((Object)this.getRrdRepository(), (Object)obj.getRrdRepository()).append((Object[])this.getTcaDataCollections().toArray(OF_DATA_COLLECTIONS), (Object[])obj.getTcaDataCollections().toArray(OF_DATA_COLLECTIONS)).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TcaDataCollectionConfig) {
            TcaDataCollectionConfig other = (TcaDataCollectionConfig)obj;
            return new EqualsBuilder().append((Object)this.getRrdRepository(), (Object)other.getRrdRepository()).append((Object[])this.getTcaDataCollections().toArray(OF_DATA_COLLECTIONS), (Object[])other.getTcaDataCollections().toArray(OF_DATA_COLLECTIONS)).isEquals();
        }
        return false;
    }
}

