/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.jaxb.JaxbUtils;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.opennms.netmgt.dao.support.FileReloadContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbConfigDao<K, V>
implements InitializingBean {
    private Class<K> m_jaxbClass;
    private String m_description;
    private Resource m_configResource;
    private FileReloadContainer<V> m_container;
    private JaxbReloadCallback m_callback = new JaxbReloadCallback();
    private Long m_reloadCheckInterval = null;

    public AbstractJaxbConfigDao(Class<K> entityClass, String description) {
        this.m_jaxbClass = entityClass;
        this.m_description = description;
    }

    public abstract V translateConfig(K var1);

    protected FileReloadContainer<V> getContainer() {
        return this.m_container;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected V loadConfig(Resource resource) {
        long startTime = System.currentTimeMillis();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Loading " + this.m_description + " configuration from " + resource);
        }
        V config = this.translateConfig(JaxbUtils.unmarshalWithTranslatedExceptions(this.m_jaxbClass, resource));
        long endTime = System.currentTimeMillis();
        this.log().info(this.createLoadedLogMessage(config, endTime - startTime));
        return config;
    }

    protected String createLoadedLogMessage(V translatedConfig, long diffTime) {
        return "Loaded " + this.getDescription() + " in " + diffTime + "ms";
    }

    public Resource getConfigResource() {
        return this.m_configResource;
    }

    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_configResource != null ? 1 : 0) != 0, (String)"property configResource must be set and be non-null");
        V config = this.loadConfig(this.m_configResource);
        this.m_container = new FileReloadContainer(config, this.m_configResource, (FileReloadCallback)this.m_callback);
        if (this.m_reloadCheckInterval != null) {
            this.m_container.setReloadCheckInterval(this.m_reloadCheckInterval.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JaxbReloadCallback
    implements FileReloadCallback<V> {
        public V reload(V object, Resource resource) {
            return AbstractJaxbConfigDao.this.loadConfig(resource);
        }
    }
}

