/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.config.jdbc.JdbcColumn;
import org.opennms.netmgt.config.jdbc.JdbcStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcQuery
implements Serializable,
Comparable<JdbcQuery> {
    private static final long serialVersionUID = -9083835215058208854L;
    private static final JdbcColumn[] OF_JDBC_COLUMNS = new JdbcColumn[0];
    @XmlAttribute(name="name", required=true)
    private String m_queryName;
    @XmlAttribute(name="recheckInterval")
    private int m_recheckInterval;
    @XmlAttribute(name="ifType", required=true)
    private String m_ifType;
    @XmlAttribute(name="resourceType", required=true)
    private String m_resourceType;
    @XmlElement(name="statement", required=true)
    private JdbcStatement m_jdbcStatement;
    @XmlAttribute(name="instance-column", required=false)
    private String m_instanceColumn;
    @XmlElementWrapper(name="columns")
    @XmlElement(name="column")
    private List<JdbcColumn> m_jdbcColumns = new ArrayList<JdbcColumn>();

    @XmlTransient
    public String getQueryName() {
        return this.m_queryName;
    }

    public void setQueryName(String queryName) {
        this.m_queryName = queryName;
    }

    @XmlTransient
    public JdbcStatement getJdbcStatement() {
        return this.m_jdbcStatement;
    }

    public void setJdbcStatement(JdbcStatement jdbcStatement) {
        this.m_jdbcStatement = jdbcStatement;
    }

    @XmlTransient
    public List<JdbcColumn> getJdbcColumns() {
        return this.m_jdbcColumns;
    }

    public void setJdbcColumns(List<JdbcColumn> jdbcColumns) {
        this.m_jdbcColumns = jdbcColumns;
    }

    public void addJdbcColumn(JdbcColumn column) {
        this.m_jdbcColumns.add(column);
    }

    public void removeJdbcColumn(JdbcColumn column) {
        this.m_jdbcColumns.remove(column);
    }

    public void removeColumnByName(String name) {
        for (JdbcColumn column : this.m_jdbcColumns) {
            if (!column.getColumnName().equals(name)) continue;
            this.m_jdbcColumns.remove(column);
            return;
        }
    }

    @XmlTransient
    public int getRecheckInterval() {
        return this.m_recheckInterval;
    }

    public void setRecheckInterval(int recheckInterval) {
        this.m_recheckInterval = recheckInterval;
    }

    @XmlTransient
    public String getIfType() {
        return this.m_ifType;
    }

    public void setIfType(String ifType) {
        this.m_ifType = ifType;
    }

    @XmlTransient
    public String getResourceType() {
        return this.m_resourceType;
    }

    public void setResourceType(String resourceType) {
        this.m_resourceType = resourceType;
    }

    @XmlTransient
    public String getInstanceColumn() {
        return this.m_instanceColumn;
    }

    public void setInstanceColumn(String instanceColumn) {
        this.m_instanceColumn = instanceColumn;
    }

    @Override
    public int compareTo(JdbcQuery obj) {
        return new CompareToBuilder().append((Object)this.getQueryName(), (Object)obj.getQueryName()).append((Object)this.getJdbcStatement(), (Object)obj.getJdbcStatement()).append((Object[])this.getJdbcColumns().toArray(OF_JDBC_COLUMNS), (Object[])obj.getJdbcColumns().toArray(OF_JDBC_COLUMNS)).append(this.getRecheckInterval(), obj.getRecheckInterval()).append((Object)this.getIfType(), (Object)obj.getIfType()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JdbcQuery) {
            JdbcQuery other = (JdbcQuery)obj;
            return new EqualsBuilder().append((Object)this.getQueryName(), (Object)other.getQueryName()).append((Object)this.getJdbcStatement(), (Object)other.getJdbcStatement()).append((Object[])this.getJdbcColumns().toArray(OF_JDBC_COLUMNS), (Object[])other.getJdbcColumns().toArray(OF_JDBC_COLUMNS)).isEquals();
        }
        return false;
    }
}

