/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.dao.jaxb.JaxbExceptionTranslator;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbUtils {
    private static final JaxbExceptionTranslator JAXB_EXCEPTION_TRANSLATOR = new JaxbExceptionTranslator();

    private static <T> Unmarshaller createUnmarshaller(Class<T> clazz) throws JAXBException {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller um = c.createUnmarshaller();
        um.setSchema(null);
        return um;
    }

    private static <T> Marshaller createMarshaller(Class<T> clazz) throws JAXBException {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller m = c.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        return m;
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader) throws JAXBException {
        return (T)JaxbUtils.createUnmarshaller(clazz).unmarshal(reader);
    }

    private static <T> T unmarshal(Class<T> clazz, InputSource source) throws JAXBException {
        return (T)JaxbUtils.createUnmarshaller(clazz).unmarshal(source);
    }

    public static <T> T unmarshal(Class<T> clazz, InputStream in) throws JAXBException {
        return JaxbUtils.unmarshal(clazz, new InputSource(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> clazz, Resource resource) throws JAXBException, IOException {
        InputStream in;
        try {
            in = resource.getInputStream();
        }
        catch (IOException e) {
            IOException newE = new IOException("Failed to open XML configuration file for resource '" + resource + "': " + e);
            newE.initCause(e);
            throw newE;
        }
        try {
            InputSource source = new InputSource(in);
            try {
                source.setSystemId(resource.getURL().toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
            T t = JaxbUtils.unmarshal(clazz, source);
            return t;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Reader reader) throws DataAccessException {
        try {
            return JaxbUtils.unmarshal(clazz, reader);
        }
        catch (JAXBException e) {
            throw JAXB_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file", e);
        }
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, InputStream in) throws DataAccessException {
        try {
            return JaxbUtils.unmarshal(clazz, in);
        }
        catch (JAXBException e) {
            throw JAXB_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file", e);
        }
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Resource resource) {
        InputStream in;
        try {
            in = resource.getInputStream();
        }
        catch (IOException e) {
            throw JAXB_EXCEPTION_TRANSLATOR.translate("opening XML configuration file for resource '" + resource + "'", e);
        }
        try {
            InputSource source = new InputSource(in);
            try {
                source.setSystemId(resource.getURL().toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
            T t = JaxbUtils.unmarshal(clazz, source);
            return t;
        }
        catch (JAXBException e) {
            throw JAXB_EXCEPTION_TRANSLATOR.translate("unmarshalling XML file for resource '" + resource + "'", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static <T> void marshal(Class<T> clazz, Object obj, Writer writer) throws IOException, JAXBException {
        JaxbUtils.createMarshaller(clazz).marshal(obj, writer);
    }
}

