/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.jdbc;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.DBTools;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectorException;
import org.opennms.netmgt.collectd.jdbc.JdbcGroupState;
import org.opennms.netmgt.config.jdbc.JdbcQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAgentState {
    private static final String JAS_NO_DATASOURCE_FOUND = "NO_DATASOURCE_FOUND";
    private boolean m_useDataSourceName;
    private String m_dataSourceName;
    private String m_driverClass;
    private String m_dbUser;
    private String m_dbPass;
    private String m_dbUrl;
    Driver m_driver = null;
    Properties m_dbProps = null;
    private String m_address;
    private HashMap<String, JdbcGroupState> m_groupStates = new HashMap();

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public JdbcAgentState(InetAddress address, Map<String, String> parameters) {
        this.m_address = address.getCanonicalHostName();
        if (parameters == null) {
            throw new NullPointerException("parameter cannot be null");
        }
    }

    public void setupDatabaseConnections(Map<String, String> parameters) {
        String dataSourceName = ParameterMap.getKeyedString(parameters, (String)"data-source", (String)JAS_NO_DATASOURCE_FOUND);
        if (dataSourceName.equals(JAS_NO_DATASOURCE_FOUND)) {
            this.m_useDataSourceName = false;
            this.setupJdbcUrl(parameters);
        } else {
            this.m_useDataSourceName = true;
            this.m_dataSourceName = dataSourceName;
        }
    }

    protected void setupJdbcUrl(Map<String, String> parameters) {
        this.m_useDataSourceName = false;
        try {
            this.m_driverClass = ParameterMap.getKeyedString(parameters, (String)"driver", (String)"com.sybase.jdbc2.jdbc.SybDriver");
            this.m_driver = (Driver)Class.forName(this.m_driverClass).newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException("Unable to load driver class: " + exp.toString(), exp);
        }
        this.log().info("Loaded JDBC driver");
        this.m_dbUrl = DBTools.constructUrl((String)ParameterMap.getKeyedString(parameters, (String)"url", (String)"jdbc:sybase:Tds:OPENNMS_JDBC_HOSTNAME/tempdb"), (String)this.m_address);
        this.log().debug("JDBC url: " + this.m_dbUrl);
        this.m_dbUser = ParameterMap.getKeyedString(parameters, (String)"user", (String)"sa");
        this.m_dbPass = ParameterMap.getKeyedString(parameters, (String)"password", (String)"");
        this.m_dbProps = new Properties();
        this.m_dbProps.setProperty("user", this.m_dbUser);
        this.m_dbProps.setProperty("password", this.m_dbPass);
    }

    public Connection getJdbcConnection() throws JdbcCollectorException {
        if (this.m_useDataSourceName) {
            throw new JdbcCollectorException("Attempt to retrieve a JDBC Connection when the collector should be using the DataSourceFactory!");
        }
        try {
            return this.m_driver.connect(this.m_dbUrl, this.m_dbProps);
        }
        catch (SQLException e) {
            throw new JdbcCollectorException("Unable to connect to JDBC URL: '" + this.m_dbUrl + "'", e);
        }
    }

    public Statement createStatement(Connection con) {
        try {
            return con.createStatement(1005, 1007);
        }
        catch (SQLException e) {
            this.log().warn("Unable to create SQL statement: " + e.getMessage());
            throw new JdbcCollectorException("Unable to create SQL statement: " + e.getMessage(), e);
        }
    }

    public ResultSet executeJdbcQuery(Statement stmt, JdbcQuery query) {
        try {
            return stmt.executeQuery(query.getJdbcStatement().getJdbcQuery());
        }
        catch (SQLException e) {
            throw new JdbcCollectorException("Unable to execute query '" + query.getQueryName() + "'! Check your jdbc-datacollection-config.xml configuration!", e);
        }
    }

    public void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void closeResultSet(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getAddress() {
        return this.m_address;
    }

    public void setAddress(String address) {
        this.m_address = address;
    }

    public boolean groupIsAvailable(String groupName) {
        JdbcGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            return false;
        }
        return groupState.isAvailable();
    }

    public void setGroupIsAvailable(String groupName, boolean available) {
        JdbcGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            groupState = new JdbcGroupState(available);
        }
        groupState.setAvailable(available);
        this.m_groupStates.put(groupName, groupState);
    }

    public boolean shouldCheckAvailability(String groupName, int recheckInterval) {
        JdbcGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            return true;
        }
        Date lastchecked = groupState.getLastChecked();
        Date now = new Date();
        return now.getTime() - lastchecked.getTime() > (long)recheckInterval;
    }

    public void didCheckGroupAvailability(String groupName) {
        JdbcGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            this.log().warn("didCheckGroupAvailability called on a group without state - this is odd");
            return;
        }
        groupState.setLastChecked(new Date());
    }

    public String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.m_dataSourceName = dataSourceName;
    }

    public boolean getUseDataSourceName() {
        return this.m_useDataSourceName;
    }

    public void setUseDataSourceName(boolean useDataSourceName) {
        this.m_useDataSourceName = useDataSourceName;
    }
}

