/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.jdbc.JdbcColumn;
import org.opennms.netmgt.config.jdbc.JdbcDataCollection;
import org.opennms.netmgt.config.jdbc.JdbcDataCollectionConfig;
import org.opennms.netmgt.config.jdbc.JdbcQuery;
import org.opennms.netmgt.config.jdbc.JdbcRrd;
import org.opennms.netmgt.config.jdbc.JdbcStatement;
import org.opennms.test.FileAnticipator;
import org.xml.sax.SAXException;

public class JdbcDataCollectionConfigTest {
    private Marshaller m;
    private Unmarshaller um;
    private FileAnticipator fa;
    private JAXBContext c;
    private JdbcDataCollectionConfig jdcc;

    @Before
    public void setUp() throws Exception {
        this.fa = new FileAnticipator();
        this.c = JAXBContext.newInstance((Class[])new Class[]{JdbcDataCollectionConfig.class});
        this.m = this.c.createMarshaller();
        this.um = this.c.createUnmarshaller();
        JdbcRrd jdbcRrd = new JdbcRrd();
        jdbcRrd.addRra("RRA:AVERAGE:0.5:1:2016");
        jdbcRrd.addRra("RRA:AVERAGE:0.5:12:1488");
        jdbcRrd.addRra("RRA:AVERAGE:0.5:288:366");
        jdbcRrd.addRra("RRA:MAX:0.5:288:366");
        jdbcRrd.addRra("RRA:MIN:0.5:288:366");
        jdbcRrd.setStep(Integer.valueOf(300));
        JdbcStatement jdbcStatement = new JdbcStatement();
        jdbcStatement.setJdbcQuery("SELECT COUNT(eventid) as EventCount\nFROM events\nWHERE eventtime\nBETWEEN (CURRENT_TIMESTAMP - INTERVAL '1 day')\nAND CURRENT_TIMESTAMP;");
        JdbcColumn column = new JdbcColumn();
        column.setColumnName("eventCount");
        column.setDataSourceName("EventCount");
        column.setDataType("GAUGE");
        column.setAlias("eventCount");
        JdbcQuery jdbcQuery = new JdbcQuery();
        jdbcQuery.setQueryName("opennmsQuery");
        jdbcQuery.setJdbcStatement(jdbcStatement);
        jdbcQuery.addJdbcColumn(column);
        jdbcQuery.setRecheckInterval(3600000);
        jdbcQuery.setIfType("all");
        jdbcQuery.setResourceType("node");
        JdbcDataCollection jdbcDataCollection = new JdbcDataCollection();
        jdbcDataCollection.setJdbcRrd(jdbcRrd);
        jdbcDataCollection.addQuery(jdbcQuery);
        jdbcDataCollection.setName("default");
        this.jdcc = new JdbcDataCollectionConfig();
        this.jdcc.addDataCollection(jdbcDataCollection);
        this.jdcc.setRrdRepository("/opt/opennms/share/rrd/snmp/");
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void generateSchema() throws Exception {
        File schemaFile = this.fa.expecting("jdbc-datacollection-config.xsd");
        this.c.generateSchema((SchemaOutputResolver)new TestOutputResolver(schemaFile));
        if (this.fa.isInitialized()) {
            this.fa.deleteExpected();
        }
    }

    @Test
    public void generateXML() throws Exception {
        StringWriter objectXML = new StringWriter();
        this.m.marshal((Object)this.jdcc, (Writer)objectXML);
        StringBuffer exampleXML = new StringBuffer();
        File jdbcCollectionConfig = new File(ClassLoader.getSystemResource("jdbc-datacollection-config.xml").getFile());
        Assert.assertTrue((String)"jdbc-datacollection-config.xml is readable", (boolean)jdbcCollectionConfig.canRead());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jdbcCollectionConfig), "UTF-8"));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            exampleXML.append(line).append("\n");
        }
        reader.close();
        System.err.println("========================================================================");
        System.err.println("Object XML:");
        System.err.println("========================================================================");
        System.err.print(objectXML.toString());
        System.err.println("========================================================================");
        System.err.println("Example XML:");
        System.err.println("========================================================================");
        System.err.print(exampleXML.toString());
        DetailedDiff myDiff = this.getDiff(objectXML, exampleXML);
        Assert.assertEquals((String)"number of XMLUnit differences between the example XML and the mock object XML is 0", (long)0L, (long)myDiff.getAllDifferences().size());
    }

    @Test
    public void readXML() throws Exception {
        File jdbcCollectionConfig = new File(ClassLoader.getSystemResource("jdbc-datacollection-config.xml").getFile());
        Assert.assertTrue((String)"jdbc-datacollection-config.xml is readable", (boolean)jdbcCollectionConfig.canRead());
        FileInputStream reader = new FileInputStream(jdbcCollectionConfig);
        this.um.setSchema(null);
        JdbcDataCollectionConfig exampleJdcc = (JdbcDataCollectionConfig)this.um.unmarshal((InputStream)reader);
        Assert.assertTrue((String)"Compare JDBC Data Collection Config objects.", (boolean)this.jdcc.equals((Object)exampleJdcc));
        ((InputStream)reader).close();
    }

    private DetailedDiff getDiff(StringWriter objectXML, StringBuffer exampleXML) throws SAXException, IOException {
        DetailedDiff myDiff = new DetailedDiff(XMLUnit.compareXML((String)exampleXML.toString(), (String)objectXML.toString()));
        List allDifferences = myDiff.getAllDifferences();
        if (allDifferences.size() > 0) {
            for (Difference d : allDifferences) {
                System.err.println(d);
            }
        }
        return myDiff;
    }

    private static class TestOutputResolver
    extends SchemaOutputResolver {
        private final File m_schemaFile;

        public TestOutputResolver(File schemaFile) {
            this.m_schemaFile = schemaFile;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            return new StreamResult(this.m_schemaFile);
        }
    }
}

