/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.jdbc.JdbcAgentState;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectionAttributeType;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectionResource;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectionSet;
import org.opennms.netmgt.collectd.jdbc.JdbcMultiInstanceCollectionResource;
import org.opennms.netmgt.collectd.jdbc.JdbcSingleInstanceCollectionResource;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.jdbc.JdbcColumn;
import org.opennms.netmgt.config.jdbc.JdbcDataCollection;
import org.opennms.netmgt.config.jdbc.JdbcQuery;
import org.opennms.netmgt.dao.JdbcDataCollectionConfigDao;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;

public class JdbcCollector
implements ServiceCollector {
    private JdbcDataCollectionConfigDao m_jdbcCollectionDao;
    private final HashMap<Integer, JdbcAgentState> m_scheduledNodes = new HashMap();
    private HashMap<String, AttributeGroupType> m_groupTypeList = new HashMap();
    private HashMap<String, JdbcCollectionAttributeType> m_attribTypeList = new HashMap();

    public JdbcDataCollectionConfigDao getJdbcCollectionDao() {
        return this.m_jdbcCollectionDao;
    }

    public void setJdbcCollectionDao(JdbcDataCollectionConfigDao jdbcCollectionDao) {
        this.m_jdbcCollectionDao = jdbcCollectionDao;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void loadAttributeGroupList(JdbcDataCollection collection) {
        for (JdbcQuery query : collection.getQueries()) {
            AttributeGroupType attribGroupType1 = new AttributeGroupType(query.getQueryName(), query.getIfType());
            this.m_groupTypeList.put(query.getQueryName(), attribGroupType1);
        }
    }

    private void loadAttributeTypeList(JdbcDataCollection collection) {
        for (JdbcQuery query : collection.getQueries()) {
            for (JdbcColumn column : query.getJdbcColumns()) {
                AttributeGroupType attribGroupType = this.m_groupTypeList.get(query.getQueryName());
                JdbcCollectionAttributeType attribType = new JdbcCollectionAttributeType(column, attribGroupType);
                this.m_attribTypeList.put(column.getColumnName(), attribType);
            }
        }
    }

    public void initialize(Map<String, String> parameters) {
        this.log().debug("initialize: Initializing JdbcCollector.");
        this.m_jdbcCollectionDao = (JdbcDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jdbcDataCollectionConfigDao", JdbcDataCollectionConfigDao.class);
        this.m_scheduledNodes.clear();
        this.initializeRrdDirs();
        this.initDatabaseConnectionFactory();
    }

    private void initializeRrdDirs() {
        this.log().debug("initializeRrdRepository: Initializing RRD repo from JdbcCollector...");
        File f = new File(this.m_jdbcCollectionDao.getConfig().getRrdRepository());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_jdbcCollectionDao.getConfig().getRrdRepository());
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal("initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal("initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initDatabaseConnectionFactory(String dataSourceName) {
        try {
            DataSourceFactory.init((String)dataSourceName);
        }
        catch (IOException e) {
            this.log().fatal("initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal("initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public void release() {
        this.m_scheduledNodes.clear();
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        this.log().debug("initialize: Initializing JDBC collection for agent: " + agent);
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        JdbcAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.log().info("initialize: Not scheduling interface for JDBC collection: " + nodeState.getAddress());
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            this.log().debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new JdbcAgentState(agent.getInetAddress(), parameters);
        this.log().info("initialize: Scheduling interface for collection: " + nodeState.getAddress());
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    public void release(CollectionAgent agent) {
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        JdbcAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.m_scheduledNodes.remove(scheduledNodeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        JdbcAgentState agentState = null;
        if (parameters == null) {
            this.log().error("Null parameters is now allowed in JdbcCollector!!");
        }
        Connection con = null;
        ResultSet results = null;
        Statement stmt = null;
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"jdbc-collection", null);
            }
            JdbcDataCollection collection = this.m_jdbcCollectionDao.getDataCollectionByName(collectionName);
            agentState = this.m_scheduledNodes.get(agent.getNodeId());
            agentState.setupDatabaseConnections(parameters);
            this.loadAttributeGroupList(collection);
            this.loadAttributeTypeList(collection);
            JdbcCollectionSet collectionSet = new JdbcCollectionSet(agent);
            collectionSet.setCollectionTimestamp(new Date());
            for (JdbcQuery query : collection.getQueries()) {
                if (agentState.shouldCheckAvailability(query.getQueryName(), query.getRecheckInterval()) && !this.isGroupAvailable(agentState, query)) {
                    this.log().warn("Group is not available.");
                    continue;
                }
                try {
                    if (!agentState.groupIsAvailable(query.getQueryName())) continue;
                    if (agentState.getUseDataSourceName()) {
                        this.initDatabaseConnectionFactory(agentState.getDataSourceName());
                        con = DataSourceFactory.getInstance((String)agentState.getDataSourceName()).getConnection();
                    } else {
                        con = agentState.getJdbcConnection();
                    }
                    stmt = agentState.createStatement(con);
                    results = agentState.executeJdbcQuery(stmt, query);
                    if (results.isBeforeFirst() && results.isAfterLast()) {
                        this.log().warn("Query '" + query.getQueryName() + "' returned no results.");
                        agentState.closeResultSet(results);
                        agentState.closeStmt(stmt);
                        continue;
                    }
                    results.last();
                    boolean singleInstance = results.getRow() == 1;
                    results.beforeFirst();
                    while (results.next()) {
                        JdbcCollectionResource resource = null;
                        if (singleInstance) {
                            resource = new JdbcSingleInstanceCollectionResource(agent);
                        } else {
                            String instance = results.getString(query.getInstanceColumn());
                            resource = new JdbcMultiInstanceCollectionResource(agent, instance, query.getResourceType());
                        }
                        for (JdbcColumn curColumn : query.getJdbcColumns()) {
                            String columnName = null;
                            columnName = curColumn.getDataSourceName() != null && curColumn.getDataSourceName().length() != 0 ? curColumn.getDataSourceName() : curColumn.getColumnName();
                            JdbcCollectionAttributeType attribType = this.m_attribTypeList.get(curColumn.getColumnName());
                            resource.setAttributeValue(attribType, results.getString(columnName));
                        }
                        collectionSet.getCollectionResources().add(resource);
                    }
                }
                catch (SQLException e) {
                    this.log().warn("There was a problem executing query '" + query.getQueryName() + "' Please review the query or configuration. Reason: " + e.getMessage());
                    agentState.closeResultSet(results);
                    agentState.closeStmt(stmt);
                    agentState.closeConnection(con);
                }
            }
            collectionSet.setStatus(1);
            JdbcCollectionSet jdbcCollectionSet = collectionSet;
            return jdbcCollectionSet;
        }
        finally {
            agentState.closeResultSet(results);
            agentState.closeStmt(stmt);
            agentState.closeConnection(con);
            if (agentState != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGroupAvailable(JdbcAgentState agentState, JdbcQuery query) {
        this.log().debug("Checking availability of group " + query.getQueryName());
        boolean status = false;
        ResultSet resultset = null;
        Connection con = null;
        try {
            if (agentState.getUseDataSourceName()) {
                this.initDatabaseConnectionFactory(agentState.getDataSourceName());
                con = DataSourceFactory.getInstance((String)agentState.getDataSourceName()).getConnection();
            } else {
                con = agentState.getJdbcConnection();
            }
            DatabaseMetaData metadata = con.getMetaData();
            resultset = metadata.getCatalogs();
            while (resultset.next()) {
                resultset.getString(1);
            }
            if (resultset != null) {
                status = true;
            }
            agentState.closeResultSet(resultset);
            agentState.closeConnection(con);
        }
        catch (SQLException sqlEx) {
            try {
                this.log().warn("Error checking group (" + query.getQueryName() + ") availability", (Throwable)sqlEx);
                agentState.setGroupIsAvailable(query.getQueryName(), status);
                status = false;
                agentState.closeResultSet(resultset);
                agentState.closeConnection(con);
            }
            catch (Throwable throwable) {
                agentState.closeResultSet(resultset);
                agentState.closeConnection(con);
                throw throwable;
            }
        }
        this.log().debug("Group " + query.getQueryName() + " is " + (status ? "" : "not") + "available ");
        agentState.setGroupIsAvailable(query.getQueryName(), status);
        return status;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_jdbcCollectionDao.getConfig().buildRrdRepository(collectionName);
    }
}

