/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.util.ilr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.util.ilr.Duration;
import org.opennms.util.ilr.LogMessage;

public class ServiceCollector {
    private String m_serviceID;
    private int m_collectionCount = 0;
    private int m_errorCount = 0;
    private int m_betweenCount = 0;
    private int m_persistCount = 0;
    private long m_totalTime = 0L;
    private long m_errorTime = 0L;
    private long m_totalBetweenTime = 0L;
    private long m_totalPersistTime;
    private long m_lastBegin = 0L;
    private long m_lastErrorBegin = 0L;
    private long m_lastEnd = 0L;
    private long m_lastPersistBegin = 0L;
    private static final String SERVICE_ID_REGEX = "(\\d+)/(\\d+.\\d+.\\d+.\\d+)/(\\w+)";
    private static final Pattern SERVICE_ID_PATTERN = Pattern.compile("(\\d+)/(\\d+.\\d+.\\d+.\\d+)/(\\w+)");

    public ServiceCollector(String serviceID) {
        this.m_serviceID = serviceID;
    }

    public String getServiceID() {
        return this.m_serviceID;
    }

    public void addMessage(LogMessage msg) {
        long end;
        if (!this.m_serviceID.equals(msg.getServiceID())) {
            throw new IllegalArgumentException("ServiceID of log message does not match serviceID of ServiceCollector: " + this.m_serviceID);
        }
        if (msg.isCollectorBeginMessage()) {
            this.m_lastBegin = msg.getDate().getTime();
            if (this.m_lastEnd > 0L) {
                this.m_totalBetweenTime += msg.getDate().getTime() - this.m_lastEnd;
                ++this.m_betweenCount;
            }
            this.m_lastEnd = 0L;
        }
        if (msg.isErrorMessage()) {
            this.m_lastErrorBegin = this.m_lastBegin;
        }
        if (msg.isCollectorEndMessage()) {
            end = msg.getDate().getTime();
            this.m_lastEnd = msg.getDate().getTime();
            if (this.m_lastBegin > 0L) {
                this.m_totalTime += end - this.m_lastBegin;
                ++this.m_collectionCount;
            }
            this.m_lastBegin = 0L;
            if (this.m_lastErrorBegin > 0L) {
                this.m_errorTime += end - this.m_lastErrorBegin;
                ++this.m_errorCount;
            }
            this.m_lastErrorBegin = 0L;
        }
        if (msg.isPersistBeginMessage()) {
            this.m_lastPersistBegin = msg.getDate().getTime();
        }
        if (msg.isPersistEndMessage()) {
            end = msg.getDate().getTime();
            msg.getDate().getTime();
            if (this.m_lastPersistBegin > 0L) {
                this.m_totalPersistTime += end - this.m_lastPersistBegin;
                ++this.m_persistCount;
            }
            this.m_lastPersistBegin = 0L;
        }
    }

    public String getParsedServiceID() {
        Matcher m = SERVICE_ID_PATTERN.matcher(this.getServiceID());
        if (m.matches()) {
            return new String(m.group(1));
        }
        return "Wrong ID";
    }

    public int getCollectionCount() {
        return this.m_collectionCount;
    }

    public int getErrorCollectionCount() {
        return this.m_errorCount;
    }

    public int getPersistCount() {
        return this.m_persistCount;
    }

    public long getTotalCollectionTime() {
        return this.m_totalTime;
    }

    public Duration getTotalCollectionDuration() {
        return new Duration(this.getTotalCollectionTime());
    }

    public long getErrorCollectionTime() {
        return this.m_errorTime;
    }

    public Duration getErrorCollectionDuration() {
        return new Duration(this.getErrorCollectionTime());
    }

    public long getSuccessfulCollectionTime() {
        return this.m_totalTime - this.m_errorTime;
    }

    public Duration getSuccessfulCollectionDuration() {
        return new Duration(this.getSuccessfulCollectionTime());
    }

    public long getTotalPersistTime() {
        return this.m_totalPersistTime;
    }

    public Duration getTotalPersistDuration() {
        return new Duration(this.getTotalPersistTime());
    }

    public int getSuccessfulCollectionCount() {
        return this.m_collectionCount - this.m_errorCount;
    }

    public double getSuccessPercentage() {
        if (this.getCollectionCount() == 0) {
            return -1.0;
        }
        return (double)this.getSuccessfulCollectionCount() * 100.0 / (double)this.getCollectionCount();
    }

    public double getErrorPercentage() {
        if (this.getCollectionCount() == 0) {
            return -1.0;
        }
        return (double)this.getErrorCollectionCount() * 100.0 / (double)this.getCollectionCount();
    }

    public long getAverageCollectionTime() {
        int count = this.getCollectionCount();
        if (count == 0) {
            return 0L;
        }
        return this.getTotalCollectionTime() / (long)count;
    }

    public Duration getAverageCollectionDuration() {
        return new Duration(this.getAverageCollectionTime());
    }

    public long getAveragePersistTime() {
        int count = this.getPersistCount();
        if (count == 0) {
            return 0L;
        }
        return this.getTotalPersistTime() / (long)count;
    }

    public Duration getAveragePersistDuration() {
        return new Duration(this.getAveragePersistTime());
    }

    public long getAverageErrorCollectionTime() {
        int count = this.getErrorCollectionCount();
        if (count == 0) {
            return 0L;
        }
        return this.getErrorCollectionTime() / (long)count;
    }

    public Duration getAverageErrorCollectionDuration() {
        return new Duration(this.getAverageErrorCollectionTime());
    }

    public long getAverageSuccessfulCollectionTime() {
        int count = this.getSuccessfulCollectionCount();
        if (count == 0) {
            return 0L;
        }
        return this.getSuccessfulCollectionTime() / (long)count;
    }

    public Duration getAverageSuccessfulCollectionDuration() {
        return new Duration(this.getAverageSuccessfulCollectionTime());
    }

    public long getAverageTimeBetweenCollections() {
        if (this.m_betweenCount == 0) {
            return 0L;
        }
        return this.m_totalBetweenTime / (long)this.m_betweenCount;
    }

    public Duration getAverageDurationBetweenCollections() {
        return new Duration(this.getAverageTimeBetweenCollections());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceCollector) {
            ServiceCollector c = (ServiceCollector)obj;
            return this.getServiceID().equals(c.getServiceID());
        }
        return false;
    }

    public int hashCode() {
        return this.getServiceID().hashCode();
    }
}

