/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.util.ilr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.util.ilr.LogMessage;

public class BaseLogMessage
implements LogMessage {
    private static final ThreadLocal<SimpleDateFormat> s_format = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,S");
        }
    };
    private static final String s_regexp = "(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}) DEBUG \\[([^\\]]+)\\] (?:[\\p{Alnum}\\.]+): collector.collect: (begin|end|error|persistDataQueueing: begin|persistDataQueueing: end): ?(\\d+/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}/[\\w-]+).*";
    private static final Pattern s_pattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}) DEBUG \\[([^\\]]+)\\] (?:[\\p{Alnum}\\.]+): collector.collect: (begin|end|error|persistDataQueueing: begin|persistDataQueueing: end): ?(\\d+/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}/[\\w-]+).*");
    private final Date m_timestamp;
    private final String m_threadName;
    private final MsgType m_msgType;
    private final String m_serviceId;

    private static MsgType toMsgType(String msgIndicator) {
        if ("error".equals(msgIndicator)) {
            return MsgType.ERROR;
        }
        if ("begin".equals(msgIndicator)) {
            return MsgType.BEGIN_COLLECTION;
        }
        if ("end".equals(msgIndicator)) {
            return MsgType.END_COLLECTION;
        }
        if ("persistDataQueueing: begin".equals(msgIndicator)) {
            return MsgType.BEGIN_PERSIST;
        }
        if ("persistDataQueueing: end".equals(msgIndicator)) {
            return MsgType.END_PERSIST;
        }
        throw new IllegalArgumentException("No MsgType corresponding to indicator " + msgIndicator);
    }

    public static Date parseTimestamp(String dateString) {
        try {
            return s_format.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(dateString + " is not a valid dateString");
        }
    }

    public static BaseLogMessage create(String logMessage) {
        Matcher m = s_pattern.matcher(logMessage);
        if (m.matches()) {
            return new BaseLogMessage(BaseLogMessage.parseTimestamp(m.group(1)), m.group(2), BaseLogMessage.toMsgType(m.group(3)), m.group(4));
        }
        return null;
    }

    private BaseLogMessage(Date timestamp, String threadName, MsgType msgType, String serviceId) {
        this.m_timestamp = timestamp;
        this.m_threadName = threadName;
        this.m_msgType = msgType;
        this.m_serviceId = serviceId;
    }

    @Override
    public Date getDate() {
        return this.m_timestamp;
    }

    @Override
    public String getThread() {
        return this.m_threadName;
    }

    public MsgType getMsgType() {
        return this.m_msgType;
    }

    @Override
    public String getServiceID() {
        return this.m_serviceId;
    }

    public boolean is(MsgType msgType) {
        return this.m_msgType.equals((Object)msgType);
    }

    @Override
    public boolean isBeginMessage() {
        return this.is(MsgType.BEGIN_COLLECTION) || this.is(MsgType.BEGIN_PERSIST);
    }

    @Override
    public boolean isCollectorBeginMessage() {
        return this.is(MsgType.BEGIN_COLLECTION);
    }

    @Override
    public boolean isCollectorEndMessage() {
        return this.is(MsgType.END_COLLECTION);
    }

    @Override
    public boolean isEndMessage() {
        return this.is(MsgType.END_COLLECTION) || this.is(MsgType.END_PERSIST);
    }

    @Override
    public boolean isErrorMessage() {
        return this.is(MsgType.ERROR);
    }

    @Override
    public boolean isPersistMessage() {
        return this.is(MsgType.BEGIN_PERSIST) || this.is(MsgType.END_PERSIST);
    }

    @Override
    public boolean isPersistBeginMessage() {
        return this.is(MsgType.BEGIN_PERSIST);
    }

    @Override
    public boolean isPersistEndMessage() {
        return this.is(MsgType.END_PERSIST);
    }

    public static enum MsgType {
        ERROR,
        BEGIN_COLLECTION,
        END_COLLECTION,
        BEGIN_PERSIST,
        END_PERSIST;

    }
}

