/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery.actors;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.network.IPAddress;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.discovery.IpAddressFilter;
import org.opennms.netmgt.discovery.messages.DiscoveryJob;
import org.opennms.netmgt.model.discovery.IPPollRange;

public class RangeChunker {
    private IpAddressFilter m_ipAddressFilter;

    public void setIpAddressFilter(IpAddressFilter ipAddressFilter) {
        this.m_ipAddressFilter = ipAddressFilter;
    }

    public List<DiscoveryJob> chunk(DiscoveryConfiguration config) {
        int chunkSize = config.getChunkSize() > 0 ? config.getChunkSize() : 100;
        double packetsPerSecond = config.getPacketsPerSecond() > 0.0 ? config.getPacketsPerSecond() : 1.0;
        String foreignSourceFromConfig = config.getForeignSource() == null || "".equals(config.getForeignSource().trim()) ? "default" : config.getForeignSource().trim();
        String locationFromConfig = config.getLocation() == null || "".equals(config.getLocation().trim()) ? "localhost" : config.getLocation().trim();
        DiscoveryConfigFactory configFactory = new DiscoveryConfigFactory(config);
        AtomicReference previousRange = new AtomicReference();
        return StreamSupport.stream(configFactory.getConfiguredAddresses().spliterator(), false).filter(address -> this.m_ipAddressFilter == null || this.m_ipAddressFilter.matches(address.getAddress())).map(address -> new IPPollRange(address.getForeignSource() == null ? foreignSourceFromConfig : address.getForeignSource(), address.getLocation() == null ? locationFromConfig : address.getLocation(), address.getAddress(), address.getAddress(), address.getTimeout(), address.getRetries())).collect(Collectors.groupingBy(range -> new ForeignSourceLocationKey(range.getForeignSource() == null ? foreignSourceFromConfig : range.getForeignSource(), range.getLocation() == null ? locationFromConfig : range.getLocation()))).entrySet().stream().flatMap(entry -> Lists.partition((List)((List)entry.getValue()), (int)chunkSize).stream().map(ranges -> {
            DiscoveryJob retval = new DiscoveryJob(ranges.stream().map(address -> {
                if (RangeChunker.isConsecutive((IPPollRange)previousRange.get(), address)) {
                    ((IPPollRange)previousRange.get()).getAddressRange().incrementEnd();
                    return null;
                }
                previousRange.set(address);
                return address;
            }).filter(Objects::nonNull).collect(Collectors.toList()), ((ForeignSourceLocationKey)entry.getKey()).getForeignSource(), ((ForeignSourceLocationKey)entry.getKey()).getLocation(), packetsPerSecond);
            previousRange.set(null);
            return retval;
        }).collect(Collectors.toList()).stream()).collect(Collectors.toList());
    }

    private static boolean isConsecutive(IPPollRange range, IPPollRange address) {
        Preconditions.checkState((boolean)BigInteger.ONE.equals(address.getAddressRange().size()));
        return range != null && new IPAddress(range.getAddressRange().getEnd()).isPredecessorOf(new IPAddress(address.getAddressRange().getEnd())) && range.getForeignSource().equals(address.getForeignSource()) && range.getLocation().equals(address.getLocation()) && range.getRetries() == address.getRetries() && range.getTimeout() == address.getTimeout();
    }

    private static class ForeignSourceLocationKey {
        private final String m_location;
        private final String m_foreignSource;

        public ForeignSourceLocationKey(String foreignSource, String location) {
            this.m_location = location;
            this.m_foreignSource = foreignSource;
        }

        public String getForeignSource() {
            return this.m_foreignSource;
        }

        public String getLocation() {
            return this.m_location;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ForeignSourceLocationKey key = (ForeignSourceLocationKey)obj;
            return new EqualsBuilder().append((Object)this.m_foreignSource, (Object)key.getForeignSource()).append((Object)this.m_location, (Object)key.getLocation()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.m_foreignSource).append((Object)this.m_location).toHashCode();
        }
    }
}

