/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.integration.api.v1.config.events.EventConfExtension;
import org.opennms.integration.api.v1.config.events.EventDefinition;
import org.opennms.integration.api.v1.config.events.LogMessage;
import org.opennms.integration.api.v1.config.events.LogMsgDestType;
import org.opennms.integration.api.v1.config.events.ManagedObject;
import org.opennms.integration.api.v1.config.events.MaskElement;
import org.opennms.integration.api.v1.config.events.Parameter;
import org.opennms.integration.api.v1.config.events.UpdateField;
import org.opennms.integration.api.v1.config.events.Varbind;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.LogDestType;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfExtensionManager
extends ConfigExtensionManager<EventConfExtension, Events> {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfExtensionManager.class);
    private final EventConfDao eventConfDao;

    public EventConfExtensionManager(EventConfDao eventConfDao) {
        super(Events.class, new Events());
        this.eventConfDao = Objects.requireNonNull(eventConfDao);
        LOG.debug("EventConfExtensionManager initialized.");
    }

    @Override
    protected Events getConfigForExtensions(Set<EventConfExtension> extensions) {
        List orderedEvents = extensions.stream().flatMap(ext -> ext.getEventDefinitions().stream()).sorted(Comparator.comparing(EventDefinition::getPriority)).map(EventConfExtensionManager::toEvent).collect(Collectors.toList());
        Events events = new Events();
        events.getEvents().addAll(orderedEvents);
        return events;
    }

    @Override
    protected void triggerReload() {
        LOG.debug("Event configuration changed. Triggering a reload.");
        this.eventConfDao.reload();
    }

    private static Event toEvent(EventDefinition def) {
        Event event = new Event();
        event.setMask(EventConfExtensionManager.toMask(def.getMask()));
        event.setUei(def.getUei());
        event.setPriority(Integer.valueOf(def.getPriority()));
        event.setEventLabel(def.getLabel());
        event.setDescr(def.getDescription());
        event.setSeverity(def.getSeverity().getLabel());
        event.setLogmsg(EventConfExtensionManager.toLogMsg(def.getLogMessage()));
        event.setOperinstruct(def.getOperatorInstructions());
        event.setAlarmData(EventConfExtensionManager.toAlarmData(def.getAlarmData()));
        List parms = def.getParameters().stream().map(EventConfExtensionManager::toParameter).collect(Collectors.toList());
        event.setParameters(parms);
        return event;
    }

    private static Logmsg toLogMsg(LogMessage l) {
        Logmsg logmsg = new Logmsg();
        logmsg.setContent(l.getContent());
        logmsg.setDest(EventConfExtensionManager.toLogDestType(l.getDestination()));
        return logmsg;
    }

    private static LogDestType toLogDestType(LogMsgDestType type) {
        if (type != null) {
            switch (type) {
                case LOGNDISPLAY: {
                    return LogDestType.LOGNDISPLAY;
                }
                case DISPLAYONLY: {
                    return LogDestType.DISPLAYONLY;
                }
                case LOGONLY: {
                    return LogDestType.LOGONLY;
                }
                case SUPPRESS: {
                    return LogDestType.SUPPRESS;
                }
                case DONOTPERSIST: {
                    return LogDestType.DONOTPERSIST;
                }
                case DISCARDTRAPS: {
                    return LogDestType.DISCARDTRAPS;
                }
            }
        }
        return LogDestType.LOGNDISPLAY;
    }

    private static Mask toMask(org.opennms.integration.api.v1.config.events.Mask m) {
        if (m == null) {
            return null;
        }
        Mask mask = new Mask();
        mask.setMaskelements(m.getMaskElements().stream().map(EventConfExtensionManager::toMaskElement).collect(Collectors.toList()));
        mask.setVarbinds(m.getVarbinds().stream().map(EventConfExtensionManager::toVarbind).collect(Collectors.toList()));
        return mask;
    }

    private static Maskelement toMaskElement(MaskElement el) {
        Maskelement maskEl = new Maskelement();
        maskEl.setMename(el.getName());
        maskEl.setMevalues(el.getValues());
        return maskEl;
    }

    private static org.opennms.netmgt.xml.eventconf.Varbind toVarbind(Varbind vb) {
        org.opennms.netmgt.xml.eventconf.Varbind varbind = new org.opennms.netmgt.xml.eventconf.Varbind();
        varbind.setVbnumber(vb.getNumber());
        varbind.setTextualConvention(vb.getTextualConvention());
        varbind.setVbvalues(vb.getValues());
        return varbind;
    }

    private static AlarmData toAlarmData(org.opennms.integration.api.v1.config.events.AlarmData alarm) {
        if (alarm == null) {
            return null;
        }
        AlarmData alarmData = new AlarmData();
        alarmData.setReductionKey(alarm.getReductionKey());
        alarmData.setClearKey(alarm.getClearKey());
        if (alarm.getType() != null) {
            alarmData.setAlarmType(Integer.valueOf(alarm.getType().getId()));
        }
        alarmData.setAutoClean(Boolean.valueOf(alarm.isAutoClean()));
        List updateFields = alarm.getUpdateFields().stream().map(EventConfExtensionManager::toUpdateField).collect(Collectors.toList());
        alarmData.setUpdateFields(updateFields);
        alarmData.setManagedObject(EventConfExtensionManager.toManagedObject(alarm.getManagedObject()));
        return alarmData;
    }

    private static org.opennms.netmgt.xml.eventconf.UpdateField toUpdateField(UpdateField u) {
        org.opennms.netmgt.xml.eventconf.UpdateField updateField = new org.opennms.netmgt.xml.eventconf.UpdateField();
        updateField.setFieldName(u.getName());
        updateField.setUpdateOnReduction(Boolean.valueOf(u.isUpdatedOnReduction()));
        return updateField;
    }

    private static org.opennms.netmgt.xml.eventconf.Parameter toParameter(Parameter p) {
        org.opennms.netmgt.xml.eventconf.Parameter parm = new org.opennms.netmgt.xml.eventconf.Parameter();
        parm.setName(p.getName());
        parm.setValue(p.getValue());
        parm.setExpand(Boolean.valueOf(p.shouldExpand()));
        return parm;
    }

    private static org.opennms.netmgt.xml.eventconf.ManagedObject toManagedObject(ManagedObject mo) {
        if (mo == null) {
            return null;
        }
        org.opennms.netmgt.xml.eventconf.ManagedObject managedObject = new org.opennms.netmgt.xml.eventconf.ManagedObject();
        managedObject.setType(mo.getType());
        return managedObject;
    }
}

