/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.graph.status;

import org.opennms.features.apilayer.utils.InterfaceMapper;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.graph.Edge;
import org.opennms.integration.api.v1.graph.Vertex;
import org.opennms.integration.api.v1.graph.VertexRef;
import org.opennms.integration.api.v1.graph.immutables.ImmutableEdge;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertex;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertexRef;
import org.opennms.integration.api.v1.graph.status.StatusInfo;
import org.opennms.integration.api.v1.graph.status.StatusProvider;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentGraphBuilder;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentProcessor;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.info.StatusInfo;
import org.opennms.netmgt.model.OnmsSeverity;
import org.osgi.framework.BundleContext;

public class StatusProviderManager
extends InterfaceMapper<StatusProvider, EnrichmentProcessor> {
    public StatusProviderManager(BundleContext bundleContext) {
        super(EnrichmentProcessor.class, bundleContext);
    }

    @Override
    public EnrichmentProcessor map(final StatusProvider extension) {
        return new EnrichmentProcessor(){

            public boolean canEnrich(GenericGraph graph) {
                return extension.canCalculate(graph.getNamespace());
            }

            public void enrich(EnrichmentGraphBuilder graphBuilder) {
                graphBuilder.getVertices().forEach(vertex -> {
                    ImmutableVertex apiVertex = ((ImmutableVertex.Builder)ImmutableVertex.newBuilder((String)vertex.getNamespace(), (String)vertex.getId()).properties(vertex.getProperties())).build();
                    StatusInfo apiStatus = extension.calculateStatus((Vertex)apiVertex);
                    graphBuilder.property(vertex, "status", (Object)StatusProviderManager.convert(apiStatus));
                });
                graphBuilder.getEdges().forEach(edge -> {
                    ImmutableEdge apiEdge = ImmutableEdge.newBuilder((String)edge.getNamespace(), (String)edge.getId(), (VertexRef)ImmutableVertexRef.newBuilder((String)edge.getSource().getNamespace(), (String)edge.getSource().getId()).build(), (VertexRef)ImmutableVertexRef.newBuilder((String)edge.getTarget().getNamespace(), (String)edge.getTarget().getId()).build()).build();
                    StatusInfo apiStatus = extension.calculateStatus((Edge)apiEdge);
                    graphBuilder.property(edge, "status", (Object)StatusProviderManager.convert(apiStatus));
                });
            }
        };
    }

    private static org.opennms.netmgt.graph.api.info.StatusInfo convert(StatusInfo apiStatus) {
        if (apiStatus == null) {
            return org.opennms.netmgt.graph.api.info.StatusInfo.builder((org.opennms.netmgt.graph.api.info.Severity)org.opennms.netmgt.graph.api.info.Severity.Normal).build();
        }
        StatusInfo.StatusInfoBuilder statusBuilder = org.opennms.netmgt.graph.api.info.StatusInfo.builder((org.opennms.netmgt.graph.api.info.Severity)StatusProviderManager.convert(apiStatus.getSeverity()));
        if (apiStatus.getCount() != 0L) {
            statusBuilder.count(apiStatus.getCount());
        }
        return statusBuilder.build();
    }

    private static org.opennms.netmgt.graph.api.info.Severity convert(Severity apiSeverity) {
        return org.opennms.netmgt.graph.api.info.Severity.createFrom((OnmsSeverity)ModelMappers.fromSeverity(apiSeverity));
    }
}

