/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.Type;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.model.AccessPointStatus;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="accesspoint")
@Entity
@Table(name="accesspoints")
public class OnmsAccessPoint
implements Serializable,
Comparable<OnmsAccessPoint> {
    private static final long serialVersionUID = -52686562234234234L;
    private String m_physAddr;
    private Integer m_nodeId;
    private String m_pollingPackage;
    private AccessPointStatus m_status = AccessPointStatus.UNKNOWN;
    private InetAddress m_controllerIpAddr;

    public OnmsAccessPoint(String physAddr, Integer nodeId, String pollingPackage) {
        this.m_physAddr = physAddr;
        this.m_nodeId = nodeId;
        this.m_pollingPackage = pollingPackage;
    }

    public OnmsAccessPoint() {
    }

    @Id
    @Column(name="physAddr", length=32, nullable=false)
    @XmlElement(name="physAddr")
    public String getPhysAddr() {
        return this.m_physAddr;
    }

    public void setPhysAddr(String physaddr) {
        this.m_physAddr = physaddr;
    }

    @Column(name="nodeId", nullable=false)
    @XmlAttribute(name="nodeId")
    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    @Column(name="pollingPackage", length=256)
    @XmlElement(name="pollingPackage")
    public String getPollingPackage() {
        return this.m_pollingPackage;
    }

    public void setPollingPackage(String pollingpackage) {
        this.m_pollingPackage = pollingpackage;
    }

    @Column(name="status", nullable=false)
    @Type(type="org.opennms.netmgt.model.AccessPointStatusUserType")
    @XmlTransient
    public AccessPointStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(AccessPointStatus status) {
        this.m_status = status;
    }

    @Column(name="controllerIpAddr")
    @XmlElement(name="controllerIpAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getControllerIpAddress() {
        return this.m_controllerIpAddr;
    }

    public void setControllerIpAddress(InetAddress ipaddr) {
        this.m_controllerIpAddr = ipaddr;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("physAddr", (Object)this.getPhysAddr()).append("pollingPackage", (Object)this.getPollingPackage()).append("status", (Object)this.getStatus()).append("controllerIpAddr", (Object)this.getControllerIpAddress()).toString();
    }

    @Override
    public int compareTo(OnmsAccessPoint o) {
        return this.m_physAddr.compareTo(o.m_physAddr);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_physAddr == null ? 0 : this.m_physAddr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnmsAccessPoint)) {
            return false;
        }
        OnmsAccessPoint other = (OnmsAccessPoint)obj;
        return !(this.m_physAddr == null ? other.m_physAddr != null : !this.m_physAddr.equalsIgnoreCase(other.m_physAddr));
    }
}

