/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AccessPointStatus implements Serializable
{
    UNKNOWN(0, "Unknown"),
    ONLINE(1, "Online"),
    OFFLINE(3, "Offline");

    private static final Map<Integer, AccessPointStatus> ID_MAP;
    private int m_id;
    private String m_label;

    private AccessPointStatus(int id, String label) {
        this.m_id = id;
        this.m_label = label;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public static AccessPointStatus get(int id) {
        if (ID_MAP.containsKey(id)) {
            return ID_MAP.get(id);
        }
        throw new IllegalArgumentException("Cannot create AccessPointStatus from unknown ID " + id);
    }

    public static AccessPointStatus get(String label) {
        for (Integer key : ID_MAP.keySet()) {
            if (!ID_MAP.get(key).getLabel().equalsIgnoreCase(label)) continue;
            return ID_MAP.get(key);
        }
        return UNKNOWN;
    }

    public static List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (AccessPointStatus value : AccessPointStatus.values()) {
            names.add(value.toString());
        }
        return names;
    }

    static {
        ID_MAP = new HashMap<Integer, AccessPointStatus>(AccessPointStatus.values().length);
        for (AccessPointStatus status : AccessPointStatus.values()) {
            ID_MAP.put(status.getId(), status);
        }
    }
}

