/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.AccessPointDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsAccessPoint;
import org.opennms.netmgt.model.OnmsAccessPointCollection;
import org.springframework.orm.hibernate3.HibernateCallback;

public class AccessPointDaoHibernate
extends AbstractDaoHibernate<OnmsAccessPoint, Integer>
implements AccessPointDao {
    public AccessPointDaoHibernate() {
        super(OnmsAccessPoint.class);
    }

    @Override
    public OnmsAccessPoint findByPhysAddr(String physaddr) {
        return (OnmsAccessPoint)this.findUnique("from OnmsAccessPoint as aps where upper(aps.physAddr) = ?", new Object[]{physaddr.toUpperCase()});
    }

    @Override
    public OnmsAccessPointCollection findByPackage(String pkg) {
        String hql = "from OnmsAccessPoint as aps where aps.pollingPackage = ?";
        OnmsAccessPointCollection aps = new OnmsAccessPointCollection();
        aps.addAll(super.find(hql, new Object[]{pkg}));
        return aps;
    }

    @Override
    public List<String> findDistinctPackagesLike(final String pkg) {
        HibernateCallback<List<String>> callback = new HibernateCallback<List<String>>(){

            public List<String> doInHibernate(Session session) throws SQLException {
                return session.createCriteria(OnmsAccessPoint.class).setProjection((Projection)Projections.groupProperty((String)"pollingPackage")).add((Criterion)Restrictions.like((String)"pollingPackage", (Object)pkg)).list();
            }
        };
        return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
    }
}

