/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.accesspointmonitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.accesspointmonitor.poller.AccessPointPoller;
import org.opennms.netmgt.config.accesspointmonitor.IpRange;
import org.opennms.netmgt.config.accesspointmonitor.Monitor;
import org.opennms.netmgt.config.accesspointmonitor.Parameter;
import org.opennms.netmgt.config.accesspointmonitor.Service;
import org.opennms.netmgt.config.accesspointmonitor.ServiceTemplate;

public class Package
implements Serializable,
Comparable<Package> {
    private static final long serialVersionUID = -988483514208208854L;
    private static final String[] OF_SPECIFICS = new String[0];
    private static final IpRange[] OF_INCLUDERANGES = new IpRange[0];
    private static final IpRange[] OF_EXCLUDERANGES = new IpRange[0];
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="filter", required=true)
    private String m_filter;
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="include-range")
    private List<IpRange> m_includeRanges = new ArrayList<IpRange>();
    @XmlElement(name="exclude-range")
    private List<IpRange> m_excludeRanges = new ArrayList<IpRange>();
    @XmlElement(name="service", required=true)
    private Service m_service;
    private boolean m_isDynamic = false;

    public Package() {
    }

    public Package(Package copy) {
        if (copy.m_name != null) {
            this.m_name = new String(copy.m_name);
        }
        if (copy.m_filter != null) {
            this.m_filter = new String(copy.m_filter);
        }
        for (String s : copy.m_specifics) {
            this.m_specifics.add(new String(s));
        }
        for (IpRange r : copy.m_includeRanges) {
            this.m_includeRanges.add(new IpRange(r));
        }
        for (IpRange r : copy.m_excludeRanges) {
            this.m_excludeRanges.add(new IpRange(r));
        }
        if (copy.m_service != null) {
            this.m_service = new Service(copy.m_service);
        }
        this.m_isDynamic = copy.m_isDynamic;
    }

    @XmlTransient
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean nameHasWildcard() {
        return this.m_name.endsWith("%");
    }

    @XmlTransient
    public String getFilter() {
        return this.m_filter;
    }

    public String getEffectiveFilter() {
        return this.m_filter.replaceAll("%packageName%", this.getName());
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    @XmlTransient
    public List<String> getSpecifics() {
        return this.m_specifics;
    }

    public void setSpecifics(List<String> specifics) {
        this.m_specifics = specifics;
    }

    public void addSpecific(String specific) {
        this.m_specifics.add(specific);
    }

    @XmlTransient
    public List<IpRange> getIncludeRanges() {
        return this.m_includeRanges;
    }

    public void setIncludeRanges(List<IpRange> includeRanges) {
        this.m_includeRanges = includeRanges;
    }

    public void addIncludeRange(IpRange includeRange) {
        this.m_includeRanges.add(includeRange);
    }

    @XmlTransient
    public List<IpRange> getExcludeRanges() {
        return this.m_excludeRanges;
    }

    public void setExcludeRanges(List<IpRange> excludeRanges) {
        this.m_excludeRanges = excludeRanges;
    }

    public void addExcludeRange(IpRange excludeRange) {
        this.m_excludeRanges.add(excludeRange);
    }

    @XmlTransient
    public Service getService() {
        return this.m_service;
    }

    public void setService(Service service) {
        this.m_service = service;
    }

    @XmlTransient
    public Service getEffectiveService() {
        Service service;
        try {
            service = (Service)this.getService().clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        ServiceTemplate template = service.getTemplate();
        if (StringUtils.isBlank((String)service.getPassiveServiceName())) {
            if (template != null && StringUtils.isNotBlank((String)template.getPassiveServiceName())) {
                service.setPassiveServiceName(template.getPassiveServiceName());
            } else {
                service.setPassiveServiceName(service.getName());
            }
        }
        if (service.getThreads() == null) {
            if (template != null && template.getThreads() != null) {
                service.setThreads(template.getThreads());
            } else {
                service.setThreads(3);
            }
        }
        if (service.getInterval() == null) {
            if (template != null && template.getInterval() != null) {
                service.setInterval(template.getInterval());
            } else {
                service.setInterval(300000L);
            }
        }
        if (StringUtils.isBlank((String)service.getStatus())) {
            if (template != null && StringUtils.isNotBlank((String)template.getStatus())) {
                service.setStatus(template.getStatus());
            } else {
                service.setStatus("on");
            }
        }
        if (template == null) {
            return service;
        }
        Map<String, String> serviceParameters = service.getParameterMap();
        Map<String, String> templateParameters = template.getParameterMap();
        for (String key : templateParameters.keySet()) {
            if (serviceParameters.containsKey(key)) continue;
            service.addParameter(new Parameter(key, templateParameters.get(key)));
        }
        return service;
    }

    public void setIsDynamic(boolean isDynamic) {
        this.m_isDynamic = isDynamic;
    }

    @XmlTransient
    public boolean getIsDynamic() {
        return this.m_isDynamic;
    }

    private static Class<? extends AccessPointPoller> findPollingStrategyClass(Monitor monitor) throws ClassNotFoundException {
        Class<AccessPointPoller> ps = Class.forName(monitor.getClassName()).asSubclass(AccessPointPoller.class);
        if (!AccessPointPoller.class.isAssignableFrom(ps)) {
            throw new MarshallingResourceFailureException("The monitor for service: " + monitor.getService() + " class-name: " + monitor.getClassName() + " must implement PollingStrategy");
        }
        return ps;
    }

    public AccessPointPoller getPoller(List<Monitor> monitors) {
        for (Monitor monitor : monitors) {
            if (monitor.getService().compareToIgnoreCase(this.m_service.getName()) != 0) continue;
            try {
                Class<? extends AccessPointPoller> psClass = Package.findPollingStrategyClass(monitor);
                return psClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to location monitor for service: %s class-name: %s", (Object[])new Object[]{monitor.getService(), monitor.getClassName()});
            }
            catch (IllegalAccessException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InstantiationException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public int compareTo(Package obj) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)obj.getName()).append((Object)this.getFilter(), (Object)obj.getFilter()).append((Object[])this.getSpecifics().toArray(OF_SPECIFICS), (Object[])obj.getSpecifics().toArray(OF_SPECIFICS)).append((Object[])this.getIncludeRanges().toArray(OF_INCLUDERANGES), (Object[])obj.getIncludeRanges().toArray(OF_INCLUDERANGES)).append((Object[])this.getExcludeRanges().toArray(OF_EXCLUDERANGES), (Object[])obj.getExcludeRanges().toArray(OF_EXCLUDERANGES)).toComparison();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_excludeRanges == null ? 0 : ((Object)this.m_excludeRanges).hashCode());
        result = 31 * result + (this.m_filter == null ? 0 : this.m_filter.hashCode());
        result = 31 * result + (this.m_includeRanges == null ? 0 : ((Object)this.m_includeRanges).hashCode());
        result = 31 * result + (this.m_isDynamic ? 1231 : 1237);
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_service == null ? 0 : this.m_service.hashCode());
        result = 31 * result + (this.m_specifics == null ? 0 : ((Object)this.m_specifics).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Package) {
            Package other = (Package)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getFilter(), (Object)other.getFilter()).append((Object[])this.getSpecifics().toArray(OF_SPECIFICS), (Object[])other.getSpecifics().toArray(OF_SPECIFICS)).append((Object[])this.getIncludeRanges().toArray(OF_INCLUDERANGES), (Object[])other.getIncludeRanges().toArray(OF_INCLUDERANGES)).append((Object[])this.getExcludeRanges().toArray(OF_EXCLUDERANGES), (Object[])other.getExcludeRanges().toArray(OF_EXCLUDERANGES)).isEquals();
        }
        return false;
    }
}

