/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.accesspointmonitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.accesspointmonitor.AccessPointMonitorConfig;
import org.xml.sax.InputSource;

public class AccessPointMonitorConfigFactory {
    private static final String ACCESS_POINT_MONITOR_CONFIG_FILE_NAME = "access-point-monitor-configuration.xml";
    private static AccessPointMonitorConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;
    private AccessPointMonitorConfig m_accessPointMonitorConfig = null;

    public static AccessPointMonitorConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(AccessPointMonitorConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getConfigFileByName((String)ACCESS_POINT_MONITOR_CONFIG_FILE_NAME);
        AccessPointMonitorConfigFactory.log().debug("init: config file path: " + cfgFile.getPath());
        FileInputStream is = null;
        try {
            is = new FileInputStream(cfgFile);
            AccessPointMonitorConfigFactory.setInstance(new AccessPointMonitorConfigFactory(cfgFile.lastModified(), is));
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public static synchronized void reload() throws IOException {
        AccessPointMonitorConfigFactory.init();
        AccessPointMonitorConfigFactory.getInstance().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws IOException {
        File cfgFile = ConfigFileConstants.getConfigFileByName((String)ACCESS_POINT_MONITOR_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            AccessPointMonitorConfigFactory.log().debug("init: config file path: " + cfgFile.getPath());
            FileInputStream is = null;
            try {
                is = new FileInputStream(cfgFile);
                this.m_accessPointMonitorConfig = AccessPointMonitorConfigFactory.unmarshall(is);
            }
            finally {
                if (is != null) {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            AccessPointMonitorConfigFactory.log().debug("init: finished loading config file: " + cfgFile.getPath());
        }
    }

    public AccessPointMonitorConfigFactory(long currentVersion, InputStream is) {
        this.m_accessPointMonitorConfig = AccessPointMonitorConfigFactory.unmarshall(is);
        this.m_currentVersion = currentVersion;
    }

    private static AccessPointMonitorConfig unmarshall(InputStream is) {
        return (AccessPointMonitorConfig)JaxbUtils.unmarshal(AccessPointMonitorConfig.class, (InputSource)new InputSource(is));
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(AccessPointMonitorConfigFactory.class);
    }

    public AccessPointMonitorConfig getConfig() {
        return this.m_accessPointMonitorConfig;
    }

    public static AccessPointMonitorConfig getConfigFromInstance() {
        return AccessPointMonitorConfigFactory.getInstance().getConfig();
    }

    public static String getDefaultConfigFilename() {
        return ACCESS_POINT_MONITOR_CONFIG_FILE_NAME;
    }
}

