/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.accesspointmonitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.config.accesspointmonitor.Monitor;
import org.opennms.netmgt.config.accesspointmonitor.Package;
import org.opennms.netmgt.config.accesspointmonitor.Service;
import org.opennms.netmgt.config.accesspointmonitor.ServiceTemplate;

@XmlRootElement(name="access-point-monitor-configuration")
public class AccessPointMonitorConfig
implements Serializable,
Comparable<AccessPointMonitorConfig> {
    private static final long serialVersionUID = -7884808420236892997L;
    private static final ServiceTemplate[] OF_TEMPLATES = new ServiceTemplate[0];
    private static final Package[] OF_PACKAGES = new Package[0];
    private static final Monitor[] OF_MONITORS = new Monitor[0];
    @XmlAttribute(name="threads")
    private int m_threads;
    @XmlAttribute(name="package-scan-interval")
    private long m_packageScanInterval;
    @XmlElement(name="service-template")
    private List<ServiceTemplate> m_serviceTemplates = new ArrayList<ServiceTemplate>();
    @XmlElement(name="package")
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="monitor")
    private List<Monitor> m_monitors = new ArrayList<Monitor>();

    @XmlTransient
    public int getThreads() {
        return this.m_threads;
    }

    public void setThreads(int threads) {
        this.m_threads = threads;
    }

    @XmlTransient
    public long getPackageScanInterval() {
        return this.m_packageScanInterval;
    }

    public void setPackageScanInterval(long packageScanInterval) {
        this.m_packageScanInterval = packageScanInterval;
    }

    @XmlTransient
    public List<ServiceTemplate> getServiceTemplates() {
        return this.m_serviceTemplates;
    }

    public void setServiceTemplates(List<ServiceTemplate> serviceTemplates) {
        this.m_serviceTemplates = serviceTemplates;
    }

    public void addServiceTemplate(ServiceTemplate svcTemplate) {
        this.m_serviceTemplates.add(svcTemplate);
    }

    @XmlTransient
    public List<Package> getPackages() {
        this.updateServiceTemplates();
        return this.m_packages;
    }

    public void setPackages(List<Package> packages) {
        this.m_packages = packages;
    }

    public void addPackage(Package pkg) {
        this.m_packages.add(pkg);
    }

    @XmlTransient
    public List<Monitor> getMonitors() {
        return this.m_monitors;
    }

    public void setMonitors(List<Monitor> monitors) {
        this.m_monitors = monitors;
    }

    public void addMonitor(Monitor monitor) {
        this.m_monitors.add(monitor);
    }

    @Override
    public int compareTo(AccessPointMonitorConfig obj) {
        return new CompareToBuilder().append(this.getThreads(), obj.getThreads()).append((Object[])this.getServiceTemplates().toArray(OF_TEMPLATES), (Object[])obj.getServiceTemplates().toArray(OF_TEMPLATES)).append((Object[])this.getPackages().toArray(OF_PACKAGES), (Object[])obj.getPackages().toArray(OF_PACKAGES)).append((Object[])this.getMonitors().toArray(OF_MONITORS), (Object[])obj.getMonitors().toArray(OF_MONITORS)).toComparison();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_monitors == null ? 0 : ((Object)this.m_monitors).hashCode());
        result = 31 * result + (int)(this.m_packageScanInterval ^ this.m_packageScanInterval >>> 32);
        result = 31 * result + (this.m_packages == null ? 0 : ((Object)this.m_packages).hashCode());
        result = 31 * result + (this.m_serviceTemplates == null ? 0 : ((Object)this.m_serviceTemplates).hashCode());
        result = 31 * result + this.m_threads;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessPointMonitorConfig) {
            AccessPointMonitorConfig other = (AccessPointMonitorConfig)obj;
            return new EqualsBuilder().append(this.getThreads(), other.getThreads()).append((Object[])this.getServiceTemplates().toArray(OF_TEMPLATES), (Object[])other.getServiceTemplates().toArray(OF_TEMPLATES)).append((Object[])this.getPackages().toArray(OF_PACKAGES), (Object[])other.getPackages().toArray(OF_PACKAGES)).append((Object[])this.getMonitors().toArray(OF_MONITORS), (Object[])other.getMonitors().toArray(OF_MONITORS)).isEquals();
        }
        return false;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.updateServiceTemplates();
    }

    public void updateServiceTemplates() {
        HashMap<String, ServiceTemplate> serviceTemplateMap = new HashMap<String, ServiceTemplate>();
        if (this.getServiceTemplates() != null) {
            for (ServiceTemplate t : this.getServiceTemplates()) {
                serviceTemplateMap.put(t.getName(), t);
            }
        }
        for (Package p : this.m_packages) {
            Service s = p.getService();
            s.setTemplate(null);
            if (StringUtils.isNotBlank((String)s.getTemplateName())) {
                if (!serviceTemplateMap.containsKey(s.getTemplateName())) continue;
                s.setTemplate((ServiceTemplate)serviceTemplateMap.get(s.getTemplateName()));
                continue;
            }
            if (!serviceTemplateMap.containsKey(s.getName())) continue;
            s.setTemplate((ServiceTemplate)serviceTemplateMap.get(s.getName()));
        }
    }
}

