/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.accesspointmonitor.poller;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.accesspointmonitor.poller.AccessPointPoller;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.accesspointmonitor.Package;
import org.opennms.netmgt.dao.AccessPointDao;
import org.opennms.netmgt.model.OnmsAccessPoint;
import org.opennms.netmgt.model.OnmsAccessPointCollection;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public class InstanceStrategy
implements AccessPointPoller {
    private static final String LESS_THAN = "<";
    private static final String GREATER_THAN = ">";
    private static final String LESS_THAN_EQUALS = "<=";
    private static final String GREATER_THAN_EQUALS = ">=";
    private static final String EQUALS = "=";
    private static final String NOT_EQUAL = "!=";
    private static final String MATCHES = "~";
    private OnmsIpInterface m_iface;
    private Package m_package;
    private Map<String, String> m_parameters;
    private AccessPointDao m_accessPointDao;

    private SnmpAgentConfig getAgentConfig(InetAddress ipaddr) {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new IllegalStateException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        agentConfig.hashCode();
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(this.m_parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(this.m_parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(this.m_parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(this.m_parameters, (String)"port", (int)agentConfig.getPort()));
        return agentConfig;
    }

    @Override
    public OnmsAccessPointCollection call() throws IOException {
        OnmsAccessPointCollection apsUp = new OnmsAccessPointCollection();
        InetAddress ipaddr = this.m_iface.getIpAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(ipaddr);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        this.log().debug("poll: setting SNMP peer attribute for interface " + hostAddress);
        String oid = ParameterMap.getKeyedString(this.m_parameters, (String)"oid", null);
        if (oid == null) {
            throw new IllegalStateException("oid parameter is not set.");
        }
        String operator = ParameterMap.getKeyedString(this.m_parameters, (String)"operator", null);
        String operand = ParameterMap.getKeyedString(this.m_parameters, (String)"operand", null);
        String matchstr = ParameterMap.getKeyedString(this.m_parameters, (String)"match", (String)"true");
        if (this.log().isDebugEnabled()) {
            this.log().debug("InstanceStrategy.poll: SnmpAgentConfig address= " + agentConfig);
        }
        try {
            SnmpObjId snmpObjectId = SnmpObjId.get((String)oid);
            Map map = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"AccessPointMonitor::InstanceStrategy", (SnmpObjId)snmpObjectId);
            if (map.size() <= 0) {
                throw new IOException("No entries found in table (possible timeout).");
            }
            for (Map.Entry entry : map.entrySet()) {
                boolean isUp = false;
                SnmpInstId instance = (SnmpInstId)entry.getKey();
                SnmpValue value = (SnmpValue)entry.getValue();
                if (this.meetsCriteria(value, operator, operand)) {
                    if ("true".equals(matchstr)) {
                        isUp = true;
                    }
                } else if ("false".equals(matchstr)) {
                    isUp = true;
                }
                if (!isUp) continue;
                String physAddr = InstanceStrategy.getPhysAddrFromInstance(instance);
                this.log().debug("AP at instance '" + instance + "' with MAC '" + physAddr + "' is considered to be ONLINE on controller '" + this.m_iface.getIpAddress() + "'");
                OnmsAccessPoint ap = this.m_accessPointDao.findByPhysAddr(physAddr);
                if (ap != null) {
                    if (ap.getPollingPackage().compareToIgnoreCase(this.getPackage().getName()) == 0) {
                        ap.setControllerIpAddress(ipaddr);
                        apsUp.add(ap);
                        continue;
                    }
                    this.log().info("AP with MAC '" + physAddr + "' is in a different package.");
                    continue;
                }
                this.log().info("No matching AP in database for instance '" + instance + "'.");
            }
        }
        catch (NumberFormatException e) {
            this.log().error("Number operator used on a non-number ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.log().error("Invalid SNMP Criteria ", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log().error("Interrupted while polling " + hostAddress, (Throwable)e);
        }
        return apsUp;
    }

    public static String getPhysAddrFromInstance(SnmpInstId instance) {
        String[] elm = instance.toString().split("\\.");
        if (elm.length != 6) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int val = Integer.parseInt(elm[i]);
            if (val < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(val));
            if (i >= 5) continue;
            sb.append(':');
        }
        return sb.toString().toUpperCase();
    }

    public static SnmpInstId getInstanceFromPhysAddr(String physAddr) {
        String[] elm = physAddr.split(":");
        if (elm.length != 6) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append(".");
            sb.append(Integer.parseInt(elm[i], 16));
        }
        return new SnmpInstId(sb.toString());
    }

    protected boolean meetsCriteria(SnmpValue result, String operator, String operand) {
        Boolean retVal = null;
        retVal = this.isCriteriaNull(result, operator, operand);
        if (retVal == null) {
            String value = result.toString();
            retVal = this.checkStringCriteria(operator, operand, value);
            if (retVal == null) {
                BigInteger val = BigInteger.valueOf(result.toLong());
                BigInteger intOperand = new BigInteger(operand);
                if (LESS_THAN.equals(operator)) {
                    return val.compareTo(intOperand) < 0;
                }
                if (LESS_THAN_EQUALS.equals(operator)) {
                    return val.compareTo(intOperand) <= 0;
                }
                if (GREATER_THAN.equals(operator)) {
                    return val.compareTo(intOperand) > 0;
                }
                if (GREATER_THAN_EQUALS.equals(operator)) {
                    return val.compareTo(intOperand) >= 0;
                }
                throw new IllegalArgumentException("operator " + operator + " is unknown");
            }
        } else if (retVal.booleanValue()) {
            return true;
        }
        return retVal;
    }

    protected Boolean checkStringCriteria(String operator, String operand, String value) {
        Boolean retVal = null;
        String effectiveValue = value;
        if (value == null) {
            effectiveValue = "";
        } else if (value.startsWith(".")) {
            effectiveValue = value.substring(1);
        }
        String effectiveOperand = operand;
        if (operand.startsWith(".") && !MATCHES.equals(operator)) {
            effectiveOperand = operand.substring(1);
        }
        if (EQUALS.equals(operator)) {
            retVal = effectiveOperand.equals(effectiveValue);
        } else if (NOT_EQUAL.equals(operator)) {
            retVal = !effectiveOperand.equals(effectiveValue);
        } else if (MATCHES.equals(operator)) {
            retVal = Pattern.compile(effectiveOperand).matcher(effectiveValue).find();
        }
        return retVal;
    }

    protected Boolean isCriteriaNull(Object result, String operator, String operand) {
        if (result == null) {
            return Boolean.FALSE;
        }
        if (operator == null || operand == null) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public void setInterfaceToPoll(OnmsIpInterface interfaceToPoll) {
        this.m_iface = interfaceToPoll;
    }

    @Override
    public OnmsIpInterface getInterfaceToPoll() {
        return this.m_iface;
    }

    @Override
    public void setPackage(Package pkg) {
        this.m_package = pkg;
    }

    @Override
    public Package getPackage() {
        return this.m_package;
    }

    @Override
    public void setPropertyMap(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    @Override
    public Map<String, String> getPropertyMap() {
        return this.m_parameters;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void setAccessPointDao(AccessPointDao accessPointDao) {
        this.m_accessPointDao = accessPointDao;
    }

    @Override
    public AccessPointDao getAccessPointDao() {
        return this.m_accessPointDao;
    }
}

