/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.accesspointmonitor;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.accesspointmonitor.PollingContext;
import org.opennms.netmgt.accesspointmonitor.poller.AccessPointPoller;
import org.opennms.netmgt.config.accesspointmonitor.AccessPointMonitorConfig;
import org.opennms.netmgt.config.accesspointmonitor.Package;
import org.opennms.netmgt.dao.AccessPointDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.AccessPointStatus;
import org.opennms.netmgt.model.OnmsAccessPoint;
import org.opennms.netmgt.model.OnmsAccessPointCollection;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpInterfaceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;

public class DefaultPollingContext
implements PollingContext {
    private static final String PASSIVE_STATUS_UEI = "uei.opennms.org/services/passiveServiceStatus";
    private ThreadCategory m_log = ThreadCategory.getInstance(this.getClass());
    private EventIpcManager m_eventMgr;
    private IpInterfaceDao m_ipInterfaceDao;
    private NodeDao m_nodeDao;
    private AccessPointDao m_accessPointDao;
    private Map<String, String> m_parameters;
    private Package m_package;
    private Scheduler m_scheduler;
    private long m_interval;
    private AccessPointMonitorConfig m_pollerConfig;
    private ExecutorService m_pool = null;

    @Override
    public void setPackage(Package pkg) {
        this.m_package = pkg;
    }

    @Override
    public Package getPackage() {
        return this.m_package;
    }

    @Override
    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    @Override
    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    @Override
    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    @Override
    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    @Override
    public void setAccessPointDao(AccessPointDao accessPointDao) {
        this.m_accessPointDao = accessPointDao;
    }

    @Override
    public AccessPointDao getAccessPointDao() {
        return this.m_accessPointDao;
    }

    @Override
    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    @Override
    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    @Override
    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    @Override
    public long getInterval() {
        return this.m_interval;
    }

    @Override
    public void setPropertyMap(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    @Override
    public Map<String, String> getPropertyMap() {
        return this.m_parameters;
    }

    @Override
    public void setPollerConfig(AccessPointMonitorConfig accesspointmonitorConfig) {
        this.m_pollerConfig = accesspointmonitorConfig;
    }

    @Override
    public AccessPointMonitorConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public ReadyRunnable getReadyRunnable() {
        return this;
    }

    @Override
    public void init() {
        this.m_pool = Executors.newFixedThreadPool(this.getPackage().getEffectiveService().getThreads());
    }

    @Override
    public void release() {
        this.m_pool.shutdown();
        this.m_pool = null;
    }

    public void run() {
        OnmsIpInterfaceList ifaces = this.getInterfaceList();
        if (ifaces.isEmpty()) {
            this.log().warn("Package '" + this.getPackage().getName() + "' was scheduled, but no interfaces were matched.");
        }
        OnmsAccessPointCollection apsDown = this.m_accessPointDao.findByPackage(this.getPackage().getName());
        if (this.log().isDebugEnabled()) {
            this.log().debug("Found " + apsDown.size() + " APs in package '" + this.getPackage().getName() + "'");
        }
        OnmsAccessPointCollection apsUp = new OnmsAccessPointCollection();
        HashSet<AccessPointPoller> callables = new HashSet<AccessPointPoller>();
        for (OnmsIpInterface iface : ifaces) {
            AccessPointPoller p = this.m_package.getPoller(this.m_pollerConfig.getMonitors());
            p.setInterfaceToPoll(iface);
            p.setAccessPointDao(this.m_accessPointDao);
            p.setPackage(this.m_package);
            p.setPropertyMap(this.m_parameters);
            callables.add(p);
        }
        boolean succesfullyPolledAController = false;
        try {
            if (this.m_pool == null) {
                this.log().warn("run() called, but no thread pool has been initialized.  Calling init()");
                this.init();
            }
            List futures = this.m_pool.invokeAll(callables);
            for (Future future : futures) {
                try {
                    apsUp.addAll((Collection)future.get());
                    succesfullyPolledAController = true;
                }
                catch (ExecutionException e) {
                    this.log().error("An error occurred while polling :" + e);
                }
            }
        }
        catch (InterruptedException e) {
            this.log().error("I was interrupted :" + e);
        }
        apsDown.removeAll(apsUp);
        if (this.log().isDebugEnabled()) {
            this.log().debug("(" + apsUp.size() + ") APs Online, (" + apsDown.size() + ") APs offline in package '" + this.getPackage().getName() + "'");
        }
        if (!succesfullyPolledAController) {
            this.log().warn("Failed to poll at least one controller in the package '" + this.getPackage().getName() + "'");
        }
        this.updateApStatus(apsUp, apsDown);
        this.log().debug("Re-scheduling the package '" + this.getPackage().getName() + "' in " + this.m_interval);
        this.m_scheduler.schedule(this.m_interval, this.getReadyRunnable());
    }

    private void updateApStatus(OnmsAccessPointCollection apsUp, OnmsAccessPointCollection apsDown) {
        Event e;
        for (OnmsAccessPoint ap : apsUp) {
            ap.setStatus(AccessPointStatus.ONLINE);
            this.m_accessPointDao.update(ap);
            try {
                e = this.createApStatusEvent(ap.getPhysAddr(), ap.getNodeId(), "UP");
                this.m_eventMgr.send(e);
            }
            catch (EventProxyException e2) {
                this.log().fatal("Error occured sending events ", (Throwable)e2);
            }
        }
        for (OnmsAccessPoint ap : apsDown) {
            ap.setStatus(AccessPointStatus.OFFLINE);
            this.m_accessPointDao.update(ap);
            try {
                e = this.createApStatusEvent(ap.getPhysAddr(), ap.getNodeId(), "DOWN");
                this.m_eventMgr.send(e);
            }
            catch (EventProxyException e3) {
                this.log().fatal("Error occured sending events ", (Throwable)e3);
            }
        }
        this.m_accessPointDao.flush();
    }

    protected OnmsIpInterfaceList getInterfaceList() {
        StringBuffer filterRules = new StringBuffer(this.getPackage().getEffectiveFilter());
        List ipList = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
        OnmsIpInterfaceList ifaces = new OnmsIpInterfaceList();
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add(Restrictions.sqlRestriction((String)"issnmpprimary = 'P'"));
        List allValidIfaces = this.getIpInterfaceDao().findMatching(criteria);
        for (OnmsIpInterface iface : allValidIfaces) {
            if (!ipList.contains(iface.getIpAddress())) continue;
            ifaces.add((Object)iface);
        }
        return ifaces;
    }

    protected InetAddress getNodeIpAddress(OnmsNode node) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add(Restrictions.sqlRestriction((String)("nodeid = " + node.getId())));
        List matchingIfaces = this.getIpInterfaceDao().findMatching(criteria);
        return ((OnmsIpInterface)matchingIfaces.get(0)).getIpAddress();
    }

    protected Event createApStatusEvent(String physAddr, Integer nodeId, String status) {
        ArrayList<Parm> parms = new ArrayList<Parm>();
        OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)nodeId);
        parms.add(this.buildParm("passiveIpAddr", this.getNodeIpAddress(node).getHostAddress()));
        parms.add(this.buildParm("passiveNodeLabel", node.getLabel()));
        parms.add(this.buildParm("passiveServiceName", this.getPackage().getEffectiveService().getPassiveServiceName()));
        parms.add(this.buildParm("passiveStatus", status));
        parms.add(this.buildParm("physAddr", physAddr));
        EventBuilder bldr = new EventBuilder(PASSIVE_STATUS_UEI, "accesspointmonitord");
        bldr.setParms(parms);
        return bldr.getEvent();
    }

    protected Parm buildParm(String parmName, String parmValue) {
        Value v = new Value();
        v.setContent(parmValue);
        Parm p = new Parm();
        p.setParmName(parmName);
        p.setValue(v);
        return p;
    }

    public boolean isReady() {
        return this.m_pool != null;
    }

    private ThreadCategory log() {
        return this.m_log;
    }
}

