/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.protocolcollector.tca.internal;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.nrtg.api.ProtocolCollector;
import org.opennms.nrtg.api.model.CollectionJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcaProtocolCollector
implements ProtocolCollector {
    private static Logger logger = LoggerFactory.getLogger(TcaProtocolCollector.class);
    private static final String PROTOCOL = "TCA";
    private SnmpStrategy m_snmpStrategy;
    private final List<String> keywords = new ArrayList<String>();

    public TcaProtocolCollector() {
        this.keywords.add("inboundDelay");
        this.keywords.add("inboundJitter");
        this.keywords.add("outboundDelay");
        this.keywords.add("outboundJitter");
        this.keywords.add("timesyncStatus");
    }

    public SnmpStrategy getSnmpStrategy() {
        return this.m_snmpStrategy;
    }

    public void setSnmpStrategy(SnmpStrategy snmpStrategy) {
        this.m_snmpStrategy = snmpStrategy;
    }

    protected String getCompositeValue(String keyword, String snmpResult) {
        String result = null;
        if (snmpResult != null && keyword != null && this.keywords.contains(keyword)) {
            String[] snmpResultSets = snmpResult.split("\\|");
            Integer amount = Integer.parseInt(snmpResultSets[1]);
            String snmpResultSubSet = snmpResultSets[amount + 1];
            String[] results = snmpResultSubSet.split(",");
            result = results[this.keywords.indexOf(keyword) + 1];
        }
        return result;
    }

    public CollectionJob collect(final CollectionJob collectionJob) {
        logger.info("TcaProtocolCollector is collecting collectionJob '{}'", (Object)collectionJob);
        SnmpAgentConfig snmpAgentConfig = SnmpAgentConfig.parseProtocolConfigurationString((String)collectionJob.getProtocolConfiguration());
        ArrayList<1> trackers = new ArrayList<1>();
        for (final String metricObjId : collectionJob.getAllMetrics()) {
            final String keyword = metricObjId.substring(metricObjId.lastIndexOf("_") + 1);
            SnmpObjId requestOid = SnmpObjId.get((String)metricObjId.substring(0, metricObjId.lastIndexOf("_")));
            SnmpObjId base = requestOid.getPrefix(requestOid.length() - 1);
            int lastId = requestOid.getLastSubId();
            SingleInstanceTracker instanceTracker = new SingleInstanceTracker(base, new SnmpInstId(lastId)){

                protected void storeResult(SnmpResult result) {
                    logger.trace("Collected SnmpValue '{}'", (Object)result);
                    SnmpValue value = result.getValue();
                    String compositeResult = TcaProtocolCollector.this.getCompositeValue(keyword, value.toDisplayString());
                    collectionJob.setMetricValue(metricObjId, "int32", compositeResult);
                }

                public void setFailed(boolean failed) {
                    super.setFailed(failed);
                    logger.trace("Collection Failed for metricObjId '{}'", (Object)metricObjId);
                    collectionJob.setMetricValue(metricObjId, "unknown", null);
                }

                public void setTimedOut(boolean timedOut) {
                    super.setTimedOut(timedOut);
                    logger.trace("Collection timedOut for metricObjId '{}'", (Object)metricObjId);
                    collectionJob.setMetricValue(metricObjId, "unknown", null);
                }
            };
            trackers.add(instanceTracker);
        }
        AggregateTracker tracker = new AggregateTracker(trackers);
        SnmpWalker walker = this.m_snmpStrategy.createWalker(snmpAgentConfig, "SnmpProtocolCollector for " + snmpAgentConfig.getAddress(), (CollectionTracker)tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return collectionJob;
    }

    public String getProtcol() {
        return PROTOCOL;
    }
}

