/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.web.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.model.PrefabGraph;

public class NrtHelper {
    public static final List<String> RRD_KEYWORDS = Arrays.asList("--", "DEF", "CDEF", "LINE", "GPRINT");

    public String cleanUpRrdGraphStringForWebUi(PrefabGraph prefabGraph, Map<String, String> externalPropertyAttributes, Map<String, String> stringPropertyAttributes) {
        String graphString = prefabGraph.getCommand();
        graphString = "--height=400 " + graphString;
        graphString = "--width=960 " + graphString;
        if (!graphString.contains("--slope-mode")) {
            graphString = "--slope-mode " + graphString;
        }
        if (!graphString.contains("--watermark")) {
            graphString = "--watermark=\"NRTG Alpha 1.0\" " + graphString;
        }
        graphString = graphString.replace("\\:", "\\\\\\\\:");
        graphString = graphString.replace("\\n", "\\\\\\\\n");
        graphString = graphString.replace("\"", "\\\\\"");
        for (String key : externalPropertyAttributes.keySet()) {
            graphString = graphString.replace("{" + key + "}", externalPropertyAttributes.get(key));
        }
        for (String key : stringPropertyAttributes.keySet()) {
            graphString = graphString.replace("{" + key + "}", stringPropertyAttributes.get(key));
        }
        return graphString;
    }

    public String generateJsMappingObject(String rrdCommand, Map<String, String> rrdGraphAttributesToMetricIds) {
        StringBuilder stringBuilder = new StringBuilder();
        String command = rrdCommand;
        Pattern pattern = Pattern.compile("DEF:.*?=(\\{.*?\\}):(.*?):");
        Matcher matcher = pattern.matcher(command);
        HashMap<String, String> rrdFileMapping = new HashMap<String, String>();
        while (matcher.find()) {
            rrdFileMapping.put(matcher.group(2), matcher.group(1));
        }
        for (Map.Entry<String, String> entry : rrdGraphAttributesToMetricIds.entrySet()) {
            String row = String.format("'%s': '%s:%s', \n", entry.getValue(), rrdFileMapping.get(entry.getKey()), entry.getKey());
            stringBuilder.append(row);
        }
        return stringBuilder.toString().substring(0, stringBuilder.toString().length() - ", \n".length());
    }
}

