/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.nrtbroker.jms.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.opennms.nrtg.api.NrtBroker;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.MeasurementSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.SimpleMessageConverter;

public class NrtBrokerJms
implements NrtBroker {
    private static Logger logger = LoggerFactory.getLogger((String)("OpenNMS.WEB." + NrtBrokerJms.class));
    private JmsTemplate m_jmsTemplate;
    private final SimpleMessageConverter simpleMessageConverter = new SimpleMessageConverter();
    Map<String, List<String>> m_messageStore = new HashMap<String, List<String>>();
    Map<String, Date> m_lastMessagePolled = new HashMap<String, Date>();

    public void publishCollectionJob(CollectionJob collectionJob) {
        logger.debug("JmsTemplate '{}'", (Object)this.m_jmsTemplate);
        this.m_jmsTemplate.convertAndSend("NrtCollectMe", (Object)collectionJob);
    }

    public List<MeasurementSet> receiveMeasurementSets(String nrtCollectionTaskId) {
        ArrayList<MeasurementSet> result = new ArrayList<MeasurementSet>();
        this.m_jmsTemplate.setReceiveTimeout(125L);
        Message message = this.m_jmsTemplate.receive(nrtCollectionTaskId);
        while (message != null) {
            try {
                MeasurementSet measurementSet = (MeasurementSet)this.simpleMessageConverter.fromMessage(message);
                result.add(measurementSet);
            }
            catch (JMSException ex) {
                logger.error("Error receiving messages", (Throwable)ex);
                return result;
            }
            catch (MessageConversionException ex) {
                logger.error("Error converting messages", (Throwable)ex);
                return result;
            }
            message = this.m_jmsTemplate.receive(nrtCollectionTaskId);
        }
        return result;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.m_jmsTemplate = jmsTemplate;
    }
}

