/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.rest;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.ncs.persistence.NCSComponentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component(value="ncsRestService")
@Path(value="NCS")
@Transactional
public class NCSRestService {
    private static final Logger LOG = LoggerFactory.getLogger(NCSRestService.class);
    @Autowired
    NCSComponentService m_componentService;
    private final ReentrantReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    public void afterPropertiesSet() throws RuntimeException {
        Assert.notNull((Object)this.m_componentService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{type}/{foreignSource}:{foreignId}")
    public NCSComponent getComponent(@PathParam(value="type") String type, @PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) {
        this.afterPropertiesSet();
        this.readLock();
        try {
            LOG.debug("getComponent: type = {}, foreignSource = {}, foreignId = {}", new Object[]{type, foreignSource, foreignId});
            if (this.m_componentService == null) {
                throw NCSRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Component service is null", new Object[0]);
            }
            if (foreignSource == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Foreign Source cannot be null", new Object[0]);
            }
            if (foreignId == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Foreign ID cannot be null", new Object[0]);
            }
            NCSComponent component = this.m_componentService.getComponent(type, foreignSource, foreignId);
            if (component == null) {
                throw NCSRestService.getException(Response.Status.NOT_FOUND, "Component of type {} not found for {}:{}", type, foreignSource, foreignId);
            }
            NCSComponent nCSComponent = component;
            return nCSComponent;
        }
        finally {
            this.readUnlock();
        }
    }

    @GET
    @Path(value="attributes")
    public ComponentList getComponentsByAttributes() {
        this.afterPropertiesSet();
        this.readLock();
        try {
            if (this.m_componentService == null) {
                throw NCSRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Component service is null", new Object[0]);
            }
            ComponentList componentList = this.m_componentService.findComponentsWithAttribute("jnxVpnPwVpnName", "ge-3/1/4.2");
            return componentList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addComponents(@QueryParam(value="deleteOrphans") boolean deleteOrphans, NCSComponent component) {
        this.afterPropertiesSet();
        this.writeLock();
        try {
            LOG.debug("addComponents: Adding component {} (deleteOrphans={})", (Object)component, (Object)deleteOrphans);
            if (this.m_componentService == null) {
                throw NCSRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Component service is null", new Object[0]);
            }
            if (component == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Component cannot be null", new Object[0]);
            }
            this.m_componentService.addOrUpdateComponents(component, deleteOrphans);
            Response response = Response.ok((Object)component).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{type}/{foreignSource}:{foreignId}")
    public NCSComponent addComponent(@QueryParam(value="deleteOrphans") boolean deleteOrphans, @PathParam(value="type") String type, @PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, NCSComponent subComponent) {
        this.afterPropertiesSet();
        this.writeLock();
        try {
            LOG.debug("addComponent: type = {}, foreignSource = {}, foreignId = {} (deleteOrphans={})", new Object[]{type, foreignSource, foreignId, deleteOrphans});
            if (this.m_componentService == null) {
                throw NCSRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Component service is null", new Object[0]);
            }
            if (type == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Type cannot be null", new Object[0]);
            }
            if (foreignSource == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Foreign Source cannot be null", new Object[0]);
            }
            if (foreignId == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Foreign ID cannot be null", new Object[0]);
            }
            if (subComponent == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Sub-component cannot be null", new Object[0]);
            }
            NCSComponent nCSComponent = this.m_componentService.addSubcomponent(type, foreignSource, foreignId, subComponent, deleteOrphans);
            return nCSComponent;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{type}/{foreignSource}:{foreignId}")
    public Response deleteComponent(@QueryParam(value="deleteOrphans") boolean deleteOrphans, @PathParam(value="type") String type, @PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) {
        this.afterPropertiesSet();
        this.writeLock();
        try {
            LOG.info("deleteComponent: Deleting component of type {} and foreignIdentity {}:{} (deleteOrphans={})", new Object[]{type, foreignSource, foreignId, deleteOrphans});
            if (this.m_componentService == null) {
                throw NCSRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Component service is null", new Object[0]);
            }
            if (type == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Type cannot be null", new Object[0]);
            }
            if (foreignSource == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Foreign Source cannot be null", new Object[0]);
            }
            if (foreignId == null) {
                throw NCSRestService.getException(Response.Status.BAD_REQUEST, "Foreign ID cannot be null", new Object[0]);
            }
            this.m_componentService.deleteComponent(type, foreignSource, foreignId, deleteOrphans);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void readLock() {
        this.m_readLock.lock();
    }

    protected void readUnlock() {
        if (this.m_globalLock.getReadHoldCount() > 0) {
            this.m_readLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.m_globalLock.getWriteHoldCount() == 0) {
            while (this.m_globalLock.getReadHoldCount() > 0) {
                this.m_readLock.unlock();
            }
            this.m_writeLock.lock();
        }
    }

    protected void writeUnlock() {
        if (this.m_globalLock.getWriteHoldCount() > 0) {
            this.m_writeLock.unlock();
        }
    }

    protected static WebApplicationException getException(Response.Status status, String msg, Object ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    @XmlRootElement(name="components")
    @JsonRootName(value="components")
    public static class ComponentList
    extends JaxbListWrapper<NCSComponent> {
        private static final long serialVersionUID = 1L;

        public ComponentList() {
        }

        public ComponentList(Collection<? extends NCSComponent> components) {
            super(components);
        }

        @XmlElement(name="component")
        @JsonProperty(value="component")
        public List<NCSComponent> getObjects() {
            return super.getObjects();
        }
    }
}

