/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.persistence;

import java.util.List;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.springframework.dao.DataAccessException;

public class NCSComponentDao
extends AbstractDaoHibernate<NCSComponent, Long>
implements NCSComponentRepository {
    public NCSComponentDao() {
        super(NCSComponent.class);
    }

    public List<NCSComponent> findByType(String type) {
        return this.find("from NCSComponent as ncs where ncs.type = ?", new Object[]{type});
    }

    public NCSComponent findByTypeAndForeignIdentity(String type, String foreignSource, String foreignId) {
        return (NCSComponent)this.findUnique("from NCSComponent as ncs where ncs.type = ? and ncs.foreignSource = ? and ncs.foreignId = ?", new Object[]{type, foreignSource, foreignId});
    }

    public List<NCSComponent> findComponentsThatDependOn(NCSComponent component) {
        return this.find("from NCSComponent as ncs where ? in elements(ncs.subcomponents)", new Object[]{component});
    }

    public List<NCSComponent> findComponentsWithChild(NCSComponent component) {
        return this.find("from NCSComponent as ncs where ? in elements(ncs.parentcomponents)", new Object[]{component});
    }

    public List<NCSComponent> findComponentsWithAttribute(String attrKey, String attrValue) {
        return this.find("from NCSComponent as ncs where ncs.attributes[?] = ?", new Object[]{attrKey, attrValue});
    }

    public List<NCSComponent> findComponentsByNodeId(int nodeid) {
        return this.find("select distinct ncs from NCSComponent as ncs, OnmsNode as n left join fetch ncs.attributes where ncs.nodeIdentification.foreignSource = n.foreignSource and ncs.nodeIdentification.foreignId = n.foreignId and n.id = ?", new Object[]{nodeid});
    }

    public Long save(NCSComponent entity) throws DataAccessException {
        this.validateEntity(entity);
        return (Long)super.save((Object)entity);
    }

    public void saveOrUpdate(NCSComponent entity) throws DataAccessException {
        this.validateEntity(entity);
        super.saveOrUpdate((Object)entity);
    }

    private void validateEntity(NCSComponent entity) throws DataAccessException {
    }

    public static final class InvalidForeignSourceException
    extends DataAccessException {
        private static final long serialVersionUID = -4762525172339952143L;

        public InvalidForeignSourceException(String msg) {
            super("Invalid Foreign Source: " + msg);
        }

        public InvalidForeignSourceException(String foreignSource, String msg) {
            super("Invalid Foreign Source (" + foreignSource + "): " + msg);
        }
    }

    public static final class InvalidForeignIdException
    extends DataAccessException {
        private static final long serialVersionUID = -762719422321681955L;

        public InvalidForeignIdException(String msg) {
            super("Invalid Foreign ID: " + msg);
        }

        public InvalidForeignIdException(String foreignId, String msg) {
            super("Invalid Foreign ID (" + foreignId + "): " + msg);
        }
    }
}

