/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.ncs.persistence.NCSComponentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="NCS")
@Transactional
public class NCSRestService {
    @Autowired
    NCSComponentService m_componentService;
    @Autowired
    EventDao m_eventDao;
    @Autowired
    AlarmDao m_alarmDao;
    @Context
    UriInfo m_uriInfo;
    private final ReentrantReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    public void afterPropertiesSet() throws RuntimeException {
        Assert.notNull((Object)this.m_componentService);
        Assert.notNull((Object)this.m_eventDao);
        Assert.notNull((Object)this.m_alarmDao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{type}/{foreignSource}:{foreignId}")
    public NCSComponent getComponent(@PathParam(value="type") String type, @PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) {
        this.afterPropertiesSet();
        this.readLock();
        try {
            LogUtils.debugf((Object)this, (String)"getComponent: type = %s, foreignSource = %s, foreignId = %s", (Object[])new Object[]{type, foreignSource, foreignId});
            if (this.m_componentService == null) {
                throw new IllegalStateException("component service is null");
            }
            NCSComponent component = this.m_componentService.getComponent(type, foreignSource, foreignId);
            if (component == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            NCSComponent nCSComponent = component;
            return nCSComponent;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="attributes")
    public ComponentList getComponentsByAttributes() {
        this.afterPropertiesSet();
        this.readLock();
        try {
            if (this.m_componentService == null) {
                throw new IllegalStateException("component service is null");
            }
            ComponentList componentList = this.m_componentService.findComponentsWithAttribute("jnxVpnPwVpnName", "ge-3/1/4.2");
            return componentList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addComponents(@QueryParam(value="deleteOrphans") boolean deleteOrphans, NCSComponent component) {
        this.afterPropertiesSet();
        this.writeLock();
        try {
            LogUtils.debugf((Object)this, (String)"addComponents: Adding component %s (deleteOrphans=%s)", (Object[])new Object[]{component, deleteOrphans});
            if (this.m_componentService == null) {
                throw new IllegalStateException("component service is null");
            }
            try {
                this.m_componentService.addOrUpdateComponents(component, deleteOrphans);
            }
            catch (DataAccessException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
            Response response = Response.ok((Object)component).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{type}/{foreignSource}:{foreignId}")
    public NCSComponent addComponent(@QueryParam(value="deleteOrphans") boolean deleteOrphans, @PathParam(value="type") String type, @PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, NCSComponent subComponent) {
        this.afterPropertiesSet();
        this.writeLock();
        try {
            LogUtils.debugf((Object)this, (String)"addComponent: type = %s, foreignSource = %s, foreignId = %s (deleteOrphans=%s)", (Object[])new Object[]{type, foreignSource, foreignId, deleteOrphans});
            if (this.m_componentService == null) {
                throw new IllegalStateException("component service is null");
            }
            if (subComponent == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            try {
                NCSComponent nCSComponent = this.m_componentService.addSubcomponent(type, foreignSource, foreignId, subComponent, deleteOrphans);
                return nCSComponent;
            }
            catch (DataAccessException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{type}/{foreignSource}:{foreignId}")
    public Response deleteComponent(@QueryParam(value="deleteOrphans") boolean deleteOrphans, @PathParam(value="type") String type, @PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) {
        this.afterPropertiesSet();
        this.writeLock();
        try {
            LogUtils.infof((Object)this, (String)"deleteComponent: Deleting component of type %s and foreignIdentity %s:%s (deleteOrphans=%s)", (Object[])new Object[]{type, foreignSource, foreignId, deleteOrphans});
            if (this.m_componentService == null) {
                throw new IllegalStateException("component service is null");
            }
            this.m_componentService.deleteComponent(type, foreignSource, foreignId, deleteOrphans);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void readLock() {
        this.m_readLock.lock();
    }

    protected void readUnlock() {
        if (this.m_globalLock.getReadHoldCount() > 0) {
            this.m_readLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.m_globalLock.getWriteHoldCount() == 0) {
            while (this.m_globalLock.getReadHoldCount() > 0) {
                this.m_readLock.unlock();
            }
            this.m_writeLock.lock();
        }
    }

    protected void writeUnlock() {
        if (this.m_globalLock.getWriteHoldCount() > 0) {
            this.m_writeLock.unlock();
        }
    }

    @XmlRootElement(name="components")
    public static class ComponentList
    extends LinkedList<NCSComponent> {
        private static final long serialVersionUID = 8031737923157780179L;
        private int m_totalCount;

        public ComponentList() {
        }

        public ComponentList(Collection<? extends NCSComponent> c) {
            super(c);
        }

        @XmlElement(name="component")
        public List<NCSComponent> getComponents() {
            return this;
        }

        public void setComponents(List<NCSComponent> components) {
            if (components == this) {
                return;
            }
            this.clear();
            this.addAll(components);
        }

        @XmlAttribute(name="count")
        public int getCount() {
            return this.size();
        }

        public void setCount(int count) {
        }

        @XmlAttribute(name="totalCount")
        public int getTotalCount() {
            return this.m_totalCount;
        }

        public void setTotalCount(int count) {
            this.m_totalCount = count;
        }
    }
}

