/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.persistence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.ncs.persistence.ComponentEventQueue;
import org.opennms.netmgt.ncs.persistence.ComponentIdentifier;
import org.opennms.netmgt.ncs.persistence.NCSComponentDao;
import org.opennms.netmgt.ncs.persistence.NCSComponentService;
import org.opennms.netmgt.ncs.rest.NCSRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class NCSComponentServiceImpl
implements NCSComponentService {
    private static final Set<NCSComponent> EMPTY_COMPONENT_SET = Collections.unmodifiableSet(new HashSet());
    @Autowired
    NCSComponentDao m_componentDao;
    @Autowired
    AlarmDao m_alarmDao;
    @Autowired
    EventDao m_eventDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    EventProxy m_eventProxy;

    @Override
    public void setEventProxy(EventProxy proxy) throws Exception {
        this.m_eventProxy = proxy;
    }

    @Override
    @Transactional
    public NCSComponent getComponent(String type, String foreignSource, String foreignId) {
        LogUtils.debugf((Object)this, (String)"getComponent(%s, %s, %s)", (Object[])new Object[]{type, foreignSource, foreignId});
        return this.getComponent(new ComponentIdentifier(null, type, foreignSource, foreignId, null, null));
    }

    @Override
    @Transactional
    public NCSRestService.ComponentList findComponentsWithAttribute(String attrKey, String attrValue) {
        LogUtils.debugf((Object)this, (String)"findComponentsWithAttribute(%s, %s)", (Object[])new Object[]{attrKey, attrValue});
        return new NCSRestService.ComponentList((Collection<? extends NCSComponent>)this.m_componentDao.findComponentsWithAttribute(attrKey, attrValue));
    }

    @Override
    @Transactional
    public NCSComponent addOrUpdateComponents(NCSComponent component, boolean deleteOrphans) {
        ComponentIdentifier componentId = this.getIdentifier(component);
        LogUtils.debugf((Object)this, (String)"addOrUpdateComponents(%s, %s)", (Object[])new Object[]{componentId, deleteOrphans});
        ComponentEventQueue ceq = new ComponentEventQueue();
        NCSComponent updatedComponent = this.addOrUpdateComponents(componentId, component, ceq, deleteOrphans);
        try {
            ceq.sendAll(this.m_eventProxy);
        }
        catch (EventProxyException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Component %s added, but an error occured while sending add/delete/update events.", (Object[])new Object[]{componentId});
        }
        return updatedComponent;
    }

    @Override
    @Transactional
    public NCSComponent addSubcomponent(String type, String foreignSource, String foreignId, NCSComponent subComponent, boolean deleteOrphans) {
        ComponentIdentifier subComponentId = this.getIdentifier(subComponent);
        LogUtils.debugf((Object)this, (String)"addSubcomponent(%s, %s, %s, %s, %s)", (Object[])new Object[]{type, foreignSource, foreignId, subComponentId, deleteOrphans});
        NCSComponent component = this.getComponent(type, foreignSource, foreignId);
        ComponentIdentifier id = this.getIdentifier(component);
        ComponentEventQueue ceq = new ComponentEventQueue();
        if (component == null) {
            throw new ObjectRetrievalFailureException(NCSComponent.class, (Object)("Unable to locate component with type=" + type + ", foreignSource=" + foreignSource + ", foreignId=" + foreignId));
        }
        NCSComponent updatedSubComponent = this.addOrUpdateComponents(subComponentId, subComponent, ceq, deleteOrphans);
        component.addSubcomponent(updatedSubComponent);
        this.m_componentDao.update(component);
        ceq.componentUpdated(id);
        try {
            ceq.sendAll(this.m_eventProxy);
        }
        catch (EventProxyException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Component %s added to %s, but an error occured while sending add/delete/update events.", (Object[])new Object[]{subComponentId, id});
        }
        return this.getComponent(id);
    }

    @Override
    @Transactional
    public void deleteComponent(String type, String foreignSource, String foreignId, boolean deleteOrphans) {
        LogUtils.debugf((Object)this, (String)"deleteSubcomponent(%s, %s, %s, %s)", (Object[])new Object[]{type, foreignSource, foreignId, deleteOrphans});
        NCSComponent component = this.getComponent(type, foreignSource, foreignId);
        ComponentIdentifier id = this.getIdentifier(component);
        ComponentEventQueue ceq = new ComponentEventQueue();
        this.deleteComponent(id, ceq, deleteOrphans);
        try {
            ceq.sendAll(this.m_eventProxy);
        }
        catch (EventProxyException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Component %s deleted, but an error occured while sending delete/update events.", (Object[])new Object[]{id});
        }
    }

    private Set<ComponentIdentifier> getIdentifiers(Collection<NCSComponent> components) {
        HashSet<ComponentIdentifier> identifiers = new HashSet<ComponentIdentifier>();
        for (NCSComponent component : components) {
            identifiers.add(this.getIdentifier(component));
        }
        return identifiers;
    }

    private ComponentIdentifier getIdentifier(NCSComponent component) {
        return new ComponentIdentifier(component.getId(), component.getType(), component.getForeignSource(), component.getForeignId(), component.getName(), component.getDependenciesRequired());
    }

    private NCSComponent getComponent(ComponentIdentifier id) {
        return this.m_componentDao.findByTypeAndForeignIdentity(id.getType(), id.getForeignSource(), id.getForeignId());
    }

    private NCSComponent addOrUpdateComponents(final ComponentIdentifier id, final NCSComponent component, final ComponentEventQueue ceq, final boolean deleteOrphans) {
        final LinkedHashSet subcomponents = new LinkedHashSet();
        NCSComponent existing = (NCSComponent)new UpsertTemplate<NCSComponent, NCSComponentDao>(this.m_transactionManager, this.m_componentDao){

            protected NCSComponent query() {
                return NCSComponentServiceImpl.this.getComponent(id);
            }

            protected NCSComponent doInsert() {
                for (NCSComponent subcomponent : component.getSubcomponents()) {
                    NCSComponent updatedComponent = NCSComponentServiceImpl.this.addOrUpdateComponents(NCSComponentServiceImpl.this.getIdentifier(subcomponent), subcomponent, ceq, deleteOrphans);
                    subcomponents.add(updatedComponent);
                }
                component.setSubcomponents(subcomponents);
                NCSComponentServiceImpl.this.m_componentDao.save(component);
                ceq.componentAdded(NCSComponentServiceImpl.this.getIdentifier(component));
                return component;
            }

            protected NCSComponent doUpdate(NCSComponent dbObj) {
                for (NCSComponent subcomponent : component.getSubcomponents()) {
                    NCSComponent updatedComponent = NCSComponentServiceImpl.this.addOrUpdateComponents(NCSComponentServiceImpl.this.getIdentifier(subcomponent), subcomponent, ceq, deleteOrphans);
                    subcomponents.add(updatedComponent);
                }
                if (deleteOrphans) {
                    NCSComponentServiceImpl.this.deleteOrphanedComponents(NCSComponentServiceImpl.this.getIdentifiers(dbObj.getSubcomponents()), NCSComponentServiceImpl.this.getIdentifiers(subcomponents), ceq);
                }
                dbObj.setName(component.getName());
                dbObj.setVersion(component.getVersion());
                dbObj.setDependenciesRequired(component.getDependenciesRequired());
                dbObj.setNodeIdentification(component.getNodeIdentification());
                dbObj.setUpEventUei(component.getUpEventUei());
                dbObj.setDownEventUei(component.getDownEventUei());
                dbObj.setAttributes(component.getAttributes());
                dbObj.setSubcomponents(subcomponents);
                NCSComponentServiceImpl.this.m_componentDao.update(dbObj);
                ceq.componentUpdated(NCSComponentServiceImpl.this.getIdentifier(dbObj));
                return dbObj;
            }
        }.execute();
        return existing;
    }

    private void deleteComponent(ComponentIdentifier id, ComponentEventQueue ceq, boolean deleteOrphans) {
        NCSComponent component = this.getComponent(id);
        if (component == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Set parentComponents = component.getParentComponents();
        Set<ComponentIdentifier> childrenIdentifiers = this.getIdentifiers(component.getSubcomponents());
        if (deleteOrphans) {
            for (ComponentIdentifier subId : childrenIdentifiers) {
                this.handleOrphanedComponents(component, subId, ceq, deleteOrphans);
            }
        }
        for (NCSComponent parent : parentComponents) {
            parent.getSubcomponents().remove(component);
            this.m_componentDao.update(parent);
        }
        component.setSubcomponents(EMPTY_COMPONENT_SET);
        this.m_componentDao.delete(component);
        this.deleteEvents(id.getForeignSource(), id.getForeignId());
        this.deleteAlarms(id.getForeignSource(), id.getForeignId());
        ceq.componentDeleted(this.getIdentifier(component));
        this.sendUpdateEvents(ceq, this.getIdentifiers(parentComponents));
    }

    private void handleOrphanedComponents(NCSComponent parent, ComponentIdentifier child, ComponentEventQueue ceq, boolean deleteOrphans) {
        ComponentIdentifier parentId = this.getIdentifier(parent);
        NCSComponent childComponent = this.getComponent(child);
        Set<ComponentIdentifier> childChildren = this.getIdentifiers(childComponent.getSubcomponents());
        Set<ComponentIdentifier> childParents = this.getIdentifiers(childComponent.getParentComponents());
        LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: parent: %s", (Object[])new Object[]{parentId});
        LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: child: %s", (Object[])new Object[]{child});
        LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: child's children: %s", (Object[])new Object[]{childChildren});
        LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: child's parents: %s", (Object[])new Object[]{childParents});
        if (childParents.size() == 1) {
            ComponentIdentifier childParent = childParents.iterator().next();
            if (childParent.equals(parentId)) {
                LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: child (%s) has only one parent (%s) and it's being deleted.", (Object[])new Object[]{child, childParent});
                this.deleteComponent(child, ceq, deleteOrphans);
            } else {
                LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: child (%s) has only one parent (%s) but it's not the one we expected. This is weird.", (Object[])new Object[]{child, childParent});
                ceq.componentUpdated(childParent);
            }
        } else {
            LogUtils.tracef((Object)this, (String)"handleOrphanedComponents: child (%s) has more than one parent, sending updates for remaining parents.", (Object[])new Object[]{child});
            for (ComponentIdentifier childParent : childParents) {
                ceq.componentUpdated(childParent);
            }
        }
    }

    private void sendUpdateEvents(ComponentEventQueue ceq, Collection<ComponentIdentifier> parentIds) {
        LogUtils.debugf((Object)this, (String)"sendUpdateEvents: parents = %s", (Object[])new Object[]{parentIds});
        for (ComponentIdentifier parentId : parentIds) {
            ceq.componentUpdated(parentId);
        }
    }

    private void deleteOrphanedComponents(Set<ComponentIdentifier> oldComponents, Set<ComponentIdentifier> newComponents, ComponentEventQueue ceq) {
        for (ComponentIdentifier id : oldComponents) {
            if (newComponents.contains(id)) continue;
            this.deleteComponent(id, ceq, true);
        }
    }

    private void deleteAlarms(String foreignSource, String foreignId) {
        OnmsCriteria alarmCriteria = new OnmsCriteria(OnmsAlarm.class).add((Criterion)Restrictions.like((String)"eventParms", (Object)("%componentForeignSource=" + foreignSource + "%"))).add((Criterion)Restrictions.like((String)"eventParms", (Object)("%componentForeignId=" + foreignId + "%")));
        for (OnmsAlarm alarm : this.m_alarmDao.findMatching(alarmCriteria)) {
            this.m_alarmDao.delete((Object)alarm);
        }
    }

    private void deleteEvents(String foreignSource, String foreignId) {
        OnmsCriteria eventCriteria = new OnmsCriteria(OnmsEvent.class).add((Criterion)Restrictions.like((String)"eventParms", (Object)("%componentForeignSource=" + foreignSource + "%"))).add((Criterion)Restrictions.like((String)"eventParms", (Object)("%componentForeignId=" + foreignId + "%")));
        for (OnmsEvent event : this.m_eventDao.findMatching(eventCriteria)) {
            this.m_eventDao.delete((Object)event);
        }
    }
}

