/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.persistence;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.netmgt.model.ncs.NCSComponent;

public final class ComponentIdentifier
implements Comparable<ComponentIdentifier> {
    private final Long m_id;
    private final String m_type;
    private final String m_name;
    private final String m_foreignSource;
    private final String m_foreignId;
    private final NCSComponent.DependencyRequirements m_dependencyRequirements;

    public ComponentIdentifier(Long id, String type, String foreignSource, String foreignId, String name, NCSComponent.DependencyRequirements requirements) {
        this.m_id = id;
        this.m_type = type;
        this.m_name = name;
        this.m_foreignSource = foreignSource;
        this.m_foreignId = foreignId;
        this.m_dependencyRequirements = requirements == null ? NCSComponent.DependencyRequirements.ALL : requirements;
    }

    public Long getId() {
        return this.m_id;
    }

    public String getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public NCSComponent.DependencyRequirements getDependencyRequirements() {
        return this.m_dependencyRequirements;
    }

    public String toString() {
        return "ComponentIdentifier[" + this.m_type + "|" + this.m_name + "|" + this.m_foreignSource + "|" + this.m_foreignId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_foreignId == null ? 0 : this.m_foreignId.hashCode());
        result = 31 * result + (this.m_foreignSource == null ? 0 : this.m_foreignSource.hashCode());
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentIdentifier)) {
            return false;
        }
        ComponentIdentifier other = (ComponentIdentifier)obj;
        if (this.m_foreignId == null ? other.m_foreignId != null : !this.m_foreignId.equals(other.m_foreignId)) {
            return false;
        }
        if (this.m_foreignSource == null ? other.m_foreignSource != null : !this.m_foreignSource.equals(other.m_foreignSource)) {
            return false;
        }
        return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
    }

    @Override
    public int compareTo(ComponentIdentifier o) {
        return new CompareToBuilder().append((Object)this.m_id, (Object)o.getId()).append((Object)this.m_foreignId, (Object)o.getForeignId()).append((Object)this.m_foreignSource, (Object)o.getForeignSource()).append((Object)this.m_type, (Object)o.getType()).append((Object)this.m_name, (Object)o.getName()).append((Object)this.m_dependencyRequirements, (Object)o.getDependencyRequirements()).toComparison();
    }
}

