/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.persistence;

import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.ncs.persistence.ComponentIdentifier;
import org.opennms.netmgt.xml.event.Event;

public final class ComponentEventQueue {
    private final Set<ComponentIdentifier> m_added = new LinkedHashSet<ComponentIdentifier>();
    private final Set<ComponentIdentifier> m_deleted = new LinkedHashSet<ComponentIdentifier>();
    private final Set<ComponentIdentifier> m_updated = new LinkedHashSet<ComponentIdentifier>();

    public void componentAdded(ComponentIdentifier identifier) {
        this.m_added.add(identifier);
        this.m_deleted.remove(identifier);
        this.m_updated.remove(identifier);
    }

    public void componentDeleted(ComponentIdentifier identifier) {
        this.m_added.remove(identifier);
        this.m_deleted.add(identifier);
        this.m_updated.remove(identifier);
    }

    public void componentUpdated(ComponentIdentifier identifier) {
        this.m_added.remove(identifier);
        this.m_deleted.remove(identifier);
        this.m_updated.add(identifier);
    }

    public void sendAll(EventProxy eventProxy) throws EventProxyException {
        String uei;
        for (ComponentIdentifier id : this.m_deleted) {
            uei = "uei.opennms.org/internal/ncs/componentDeleted";
            eventProxy.send(this.getEvent("uei.opennms.org/internal/ncs/componentDeleted", id));
        }
        for (ComponentIdentifier id : this.m_added) {
            uei = "uei.opennms.org/internal/ncs/componentAdded";
            eventProxy.send(this.getEvent("uei.opennms.org/internal/ncs/componentAdded", id));
        }
        for (ComponentIdentifier id : this.m_updated) {
            uei = "uei.opennms.org/internal/ncs/componentUpdated";
            eventProxy.send(this.getEvent("uei.opennms.org/internal/ncs/componentUpdated", id));
        }
    }

    private Event getEvent(String uei, ComponentIdentifier id) {
        EventBuilder builder = new EventBuilder(uei, "NCSComponentService");
        builder.addParam("componentId", id.getId().longValue());
        builder.addParam("componentType", id.getType());
        builder.addParam("componentName", id.getName());
        builder.addParam("componentForeignSource", id.getForeignSource());
        builder.addParam("componentForeignId", id.getForeignId());
        builder.addParam("dependencyRequirements", id.getDependencyRequirements().toString());
        Event event = builder.getEvent();
        return event;
    }
}

